/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal.transport;

import com.google.gson.Gson;
import com.sensorberg.sdk.internal.interfaces.PlatformIdentifier;
import com.sensorberg.sdk.internal.transport.interfaces.RetrofitApiService;
import com.sensorberg.sdk.internal.transport.model.HistoryBody;
import com.sensorberg.sdk.internal.transport.model.SettingsResponse;
import com.sensorberg.sdk.model.server.BaseResolveResponse;
import com.sensorberg.sdk.model.server.ResolveResponse;
import com.sensorberg.utils.Objects;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Url;

public class RetrofitApiServiceImpl {
    private static final int CONNECTION_TIMEOUT = 30;
    private static final long HTTP_RESPONSE_DISK_CACHE_MAX_SIZE = 0x500000L;
    private final Gson mGson;
    private final PlatformIdentifier mPlatformIdentifier;
    private String mApiToken;
    private final RetrofitApiService mApiService;
    private OkHttpClient mClient;
    private HttpLoggingInterceptor httpLoggingInterceptor;
    private final Interceptor headerAuthorizationInterceptor = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Headers.Builder headersBuilder = request.headers().newBuilder().add("User-Agent", RetrofitApiServiceImpl.this.mPlatformIdentifier.getUserAgentString()).add("X-iid", RetrofitApiServiceImpl.this.mPlatformIdentifier.getDeviceInstallationIdentifier());
            if (RetrofitApiServiceImpl.this.mPlatformIdentifier.getAdvertiserIdentifier() != null) {
                headersBuilder.add("X-aid", RetrofitApiServiceImpl.this.mPlatformIdentifier.getAdvertiserIdentifier());
            }
            if (RetrofitApiServiceImpl.this.mApiToken != null) {
                headersBuilder.add("X-Api-Key", RetrofitApiServiceImpl.this.mApiToken);
            }
            request = request.newBuilder().headers(headersBuilder.build()).build();
            return chain.proceed(request);
        }
    };

    public RetrofitApiServiceImpl(File cacheFolder, Gson gson, PlatformIdentifier platformId, String baseUrl) {
        this.mGson = gson;
        this.mPlatformIdentifier = platformId;
        Retrofit restAdapter = new Retrofit.Builder().baseUrl(baseUrl).client(this.getOkHttpClient(cacheFolder)).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.mGson)).build();
        this.mApiService = (RetrofitApiService)restAdapter.create(RetrofitApiService.class);
    }

    private OkHttpClient getOkHttpClient(File baseDir) {
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder();
        okClientBuilder.addInterceptor(this.headerAuthorizationInterceptor);
        this.httpLoggingInterceptor = new HttpLoggingInterceptor();
        this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
        okClientBuilder.addInterceptor((Interceptor)this.httpLoggingInterceptor);
        okClientBuilder.retryOnConnectionFailure(true);
        if (baseDir != null) {
            File cacheDir = new File(baseDir, "HttpResponseCache");
            okClientBuilder.cache(new Cache(cacheDir, 0x500000L));
        }
        okClientBuilder.connectTimeout(30L, TimeUnit.SECONDS);
        okClientBuilder.readTimeout(30L, TimeUnit.SECONDS);
        okClientBuilder.writeTimeout(30L, TimeUnit.SECONDS);
        this.mClient = okClientBuilder.build();
        return this.mClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggingEnabled(boolean enabled) {
        Gson gson = this.mGson;
        synchronized (gson) {
            if (enabled) {
                this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            } else {
                this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
            }
        }
    }

    public Call<BaseResolveResponse> updateBeaconLayout() {
        return this.mApiService.updateBeaconLayout(this.mApiToken);
    }

    public Call<ResolveResponse> getBeacon(@Header(value="X-pid") String beaconId, @Header(value="X-qos") String networkInfo) {
        return this.mApiService.getBeacon(beaconId, networkInfo, this.mApiToken);
    }

    public Call<ResolveResponse> publishHistory(@Body HistoryBody body) {
        return this.mApiService.publishHistory(body);
    }

    public Call<SettingsResponse> getSettings() {
        return this.getSettings(this.mApiToken);
    }

    public Call<SettingsResponse> getSettings(@Url String url) {
        return this.mApiService.getSettings(url);
    }

    public boolean setApiToken(String newToken) {
        boolean tokensDiffer;
        boolean bl = tokensDiffer = this.mApiToken != null && !Objects.equals(newToken, this.mApiToken);
        if (tokensDiffer && this.mClient != null) {
            try {
                this.mClient.cache().evictAll();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.mApiToken = newToken;
        return tokensDiffer;
    }
}

