/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk;

import android.annotation.TargetApi;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.InternalApplicationBootstrapper;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.MinimalBootstrapper;
import com.sensorberg.sdk.SensorbergServiceConfiguration;
import com.sensorberg.sdk.SensorbergServiceMessage;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.FileManager;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.Platform;
import com.sensorberg.sdk.internal.interfaces.PlatformIdentifier;
import com.sensorberg.sdk.internal.interfaces.ServiceScheduler;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.receivers.GenericBroadcastReceiver;
import com.sensorberg.sdk.receivers.ScannerBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolverConfiguration;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

public class SensorbergService
extends Service {
    @Inject
    protected FileManager fileManager;
    @Inject
    protected ServiceScheduler serviceScheduler;
    @Inject
    @Named(value="realHandlerManager")
    protected HandlerManager handlerManager;
    @Inject
    @Named(value="realClock")
    protected Clock clock;
    @Inject
    @Named(value="androidBluetoothPlatform")
    protected BluetoothPlatform bluetoothPlatform;
    @Inject
    @Named(value="realTransport")
    protected Transport transport;
    @Inject
    @Named(value="androidPlatformIdentifier")
    protected PlatformIdentifier platformIdentifier;
    @Inject
    @Named(value="androidPlatform")
    protected Platform platform;
    protected MessengerList presentationDelegates = new MessengerList();
    protected InternalApplicationBootstrapper bootstrapper;

    public void onCreate() {
        super.onCreate();
        SensorbergSdk.init(this.getBaseContext());
        SensorbergSdk.getComponent().inject(this);
        Logger.log.logServiceState("onCreate");
    }

    protected void logError(String message) {
        Logger.log.logError(message);
    }

    protected void logError(String message, Exception e) {
        Logger.log.logError(message, e);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Logger.log.logServiceState("onStartCommand");
        if (!this.bluetoothPlatform.isBluetoothLowEnergySupported()) {
            this.logError("isBluetoothLowEnergySupported not true, shutting down.");
            return this.stopSensorbergService();
        }
        if (!this.platform.registerBroadcastReceiver()) {
            this.logError("no BroadcastReceiver registered for Action:com.sensorberg.android.PRESENT_ACTION");
            return this.stopSensorbergService();
        }
        SensorbergSdk.init(this.getBaseContext());
        if (intent == null) {
            return this.restartSensorbergService();
        }
        return this.handleIntent(intent);
    }

    protected int handleIntent(Intent intent) {
        Logger.log.serviceHandlesMessage(SensorbergServiceMessage.stringFrom(intent.getIntExtra("com.sensorberg.android.sdk.intent.generic.type", -1)));
        this.handleDebuggingIntent(intent, (Context)this, true);
        if (this.handleIntentEvenIfNoBootstrapperPresent(intent)) {
            return this.stopSensorbergService();
        }
        if (this.bootstrapper == null) {
            this.updateDiskConfiguration(intent);
        }
        if (intent.hasExtra("com.sensorberg.android.sdk.intent.startService")) {
            return this.startSensorbergService(intent.getStringExtra("com.sensorberg.android.sdk.intent.apiKey"));
        }
        if (intent.hasExtra("com.sensorberg.android.sdk.intent.generic.type")) {
            return this.handleIntentMessage(intent);
        }
        return 1;
    }

    protected int startSensorbergService(String apiKey) {
        if (this.bootstrapper == null && !TextUtils.isEmpty((CharSequence)apiKey)) {
            ResolverConfiguration configuration = new ResolverConfiguration();
            configuration.setApiToken(apiKey);
            this.bootstrapper = this.createBootstrapper(configuration);
            this.persistConfiguration(this.bootstrapper.resolver.configuration);
            this.bootstrapper.startScanning();
            return 1;
        }
        if (this.bootstrapper != null) {
            this.bootstrapper.startScanning();
            this.logError("start intent was sent, but the scanner was already set up");
            return 1;
        }
        this.logError("Intent to start the service was not correctly sent. not starting the service");
        return this.stopSensorbergService();
    }

    protected int restartSensorbergService() {
        this.logError("there was no intent in onStartCommand we must assume we are beeing restarted due to a kill event");
        this.bootstrapper = this.createBootstrapperFromDiskConfiguration();
        if (this.bootstrapper != null) {
            this.bootstrapper.startScanning();
        }
        return 1;
    }

    protected int stopSensorbergService() {
        this.stopSelf();
        return 2;
    }

    protected void handleDebuggingIntent(Intent intent, Context context, boolean showMessage) {
        switch (intent.getIntExtra("com.sensorberg.android.sdk.intent.generic.type", -1)) {
            case 103: {
                Logger.log = Logger.QUIET_LOG;
                this.transport.setLoggingEnabled(false);
                if (!showMessage) break;
                Toast.makeText((Context)context, (CharSequence)("Log disabled " + context.getPackageName()), (int)0).show();
                break;
            }
            case 104: {
                Logger.enableVerboseLogging();
                this.transport.setLoggingEnabled(true);
                if (!showMessage) break;
                Toast.makeText((Context)context, (CharSequence)("Log enabled " + context.getPackageName()), (int)0).show();
            }
        }
    }

    protected SensorbergServiceConfiguration loadOrCreateNewServiceConfiguration(FileManager fileManager) {
        SensorbergServiceConfiguration diskConf = SensorbergServiceConfiguration.loadFromDisk(fileManager);
        if (diskConf == null) {
            diskConf = new SensorbergServiceConfiguration(new ResolverConfiguration());
        } else if (diskConf.resolverConfiguration == null) {
            diskConf.resolverConfiguration = new ResolverConfiguration();
        }
        return diskConf;
    }

    protected void updateDiskConfiguration(Intent intent) {
        if (intent.hasExtra("com.sensorberg.android.sdk.intent.generic.type")) {
            int type = intent.getIntExtra("com.sensorberg.android.sdk.intent.generic.type", -1);
            SensorbergServiceConfiguration diskConf = this.loadOrCreateNewServiceConfiguration(this.fileManager);
            Logger.log.serviceHandlesMessage(SensorbergServiceMessage.stringFrom(type));
            switch (type) {
                case 3: {
                    if (!intent.hasExtra("com.sensorberg.android.sdk.message.setApiToken.apiTokenString")) break;
                    String apiToken = intent.getStringExtra("com.sensorberg.android.sdk.message.setApiToken.apiTokenString");
                    diskConf.resolverConfiguration.setApiToken(apiToken);
                    break;
                }
                case 12: {
                    if (!intent.hasExtra("com.sensorberg.android.sdk.message.setAdvertisingIdentifier.advertisingIdentifier")) break;
                    String advertisingIdentifier = intent.getStringExtra("com.sensorberg.android.sdk.message.setAdvertisingIdentifier.advertisingIdentifier");
                    diskConf.resolverConfiguration.setAdvertisingIdentifier(advertisingIdentifier);
                }
            }
            diskConf.writeToDisk(this.fileManager);
        }
    }

    protected boolean handleIntentEvenIfNoBootstrapperPresent(Intent intent) {
        if (intent.hasExtra("com.sensorberg.android.sdk.intent.generic.type")) {
            int type = intent.getIntExtra("com.sensorberg.android.sdk.intent.generic.type", -1);
            switch (type) {
                case 6: {
                    Logger.log.serviceHandlesMessage(SensorbergServiceMessage.stringFrom(type));
                    MinimalBootstrapper minimalBootstrapper = this.bootstrapper != null ? this.bootstrapper : new MinimalBootstrapper(this.serviceScheduler);
                    SensorbergServiceConfiguration.removeConfigurationFromDisk(this.fileManager);
                    ScannerBroadcastReceiver.setManifestReceiverEnabled(false, (Context)this);
                    GenericBroadcastReceiver.setManifestReceiverEnabled(false, (Context)this);
                    minimalBootstrapper.unscheduleAllPendingActions();
                    minimalBootstrapper.stopScanning();
                    minimalBootstrapper.stopAllScheduledOperations();
                    this.bootstrapper = null;
                    return true;
                }
            }
        }
        return false;
    }

    protected InternalApplicationBootstrapper createBootstrapperFromDiskConfiguration() {
        InternalApplicationBootstrapper newBootstrapper = null;
        try {
            SensorbergServiceConfiguration diskConf = SensorbergServiceConfiguration.loadFromDisk(this.fileManager);
            if (diskConf != null && diskConf.isComplete()) {
                newBootstrapper = this.createBootstrapper(diskConf.resolverConfiguration);
            } else {
                this.logError("configuration from disk could not be loaded or is not complete");
            }
        }
        catch (Exception e) {
            this.logError("something went wrong when loading the configuration from disk", e);
        }
        return newBootstrapper;
    }

    private InternalApplicationBootstrapper createBootstrapper(ResolverConfiguration resolverConfiguration) {
        InternalApplicationBootstrapper newBootstrapper = new InternalApplicationBootstrapper(this.transport, this.serviceScheduler, this.handlerManager, this.clock, this.bluetoothPlatform, resolverConfiguration);
        return newBootstrapper;
    }

    private void persistConfiguration(ResolverConfiguration resolverConfiguration) {
        SensorbergServiceConfiguration conf = new SensorbergServiceConfiguration(resolverConfiguration);
        conf.writeToDisk(this.fileManager);
    }

    protected int handleIntentMessage(Intent intent) {
        int what = intent.getIntExtra("com.sensorberg.android.sdk.intent.generic.type", -1);
        Logger.log.serviceHandlesMessage(SensorbergServiceMessage.stringFrom(what));
        if (!this.isBootstrapperInitialized()) {
            this.logError("couldn't start the SDK!");
            return this.stopSensorbergService();
        }
        switch (what) {
            case 11: {
                this.bootstrapper.updateBeaconLayout();
                break;
            }
            case 9: {
                Bundle message = (Bundle)intent.getParcelableExtra("com.sensorberg.android.sdk.intent.generic.what");
                this.bootstrapper.scanner.handlePlatformMessage(message);
                break;
            }
            case 102: {
                this.bootstrapper.updateSettings();
                break;
            }
            case 10: {
                this.bootstrapper.uploadHistory();
                break;
            }
            case 1001: {
                this.presentBeaconEvent(intent);
                break;
            }
            case 1: {
                this.bootstrapper.hostApplicationInForeground();
                break;
            }
            case 2: {
                this.bootstrapper.hostApplicationInBackground();
                break;
            }
            case 3: {
                this.setApiToken(intent);
                break;
            }
            case 100: {
                this.registerPresentationDelegate(intent);
                break;
            }
            case 101: {
                this.unregisterPresentationDelegate(intent);
                break;
            }
            case 7: {
                this.bootstrapper.startScanning();
                break;
            }
            case 8: {
                this.processBluetoothStateMessage(intent);
                break;
            }
            case 12: {
                this.setAdvertisingIdentifier(intent);
                break;
            }
            case 13: {
                if (intent.getBooleanExtra("com.sensorberg.android.sdk.intent.permissionState", false)) {
                    Log.i((String)"Location Permission", (String)"scanner should stop");
                    this.bootstrapper.stopScanning();
                    break;
                }
                this.bootstrapper.startScanning();
                Log.i((String)"Location Permission", (String)"scanner should start");
            }
        }
        return 1;
    }

    protected boolean isBootstrapperInitialized() {
        if (this.bootstrapper == null) {
            this.bootstrapper = this.createBootstrapperFromDiskConfiguration();
        }
        return this.bootstrapper != null;
    }

    protected void presentBeaconEvent(Intent intent) {
        try {
            BeaconEvent beaconEvent = (BeaconEvent)intent.getParcelableExtra("com.sensorberg.android.sdk.intent.generic.what");
            int index = intent.getIntExtra("com.sensorberg.android.sdk.intent.generic.index", 0);
            Logger.log.beaconResolveState(beaconEvent, "end of the delay, now showing the BeaconEvent");
            this.bootstrapper.presentEventDirectly(beaconEvent, index);
        }
        catch (Exception e) {
            this.logError("Problem showing BeaconEvent: " + e.getMessage());
        }
    }

    protected void setApiToken(Intent intent) {
        if (intent.hasExtra("com.sensorberg.android.sdk.message.setApiToken.apiTokenString")) {
            String apiToken = intent.getStringExtra("com.sensorberg.android.sdk.message.setApiToken.apiTokenString");
            this.bootstrapper.setApiToken(apiToken);
            this.persistConfiguration(this.bootstrapper.resolver.configuration);
        }
    }

    protected void registerPresentationDelegate(Intent intent) {
        if (intent.hasExtra("com.sensorberg.android.sdk.intent.messenger")) {
            Messenger messenger = (Messenger)intent.getParcelableExtra("com.sensorberg.android.sdk.intent.messenger");
            this.presentationDelegates.add(messenger);
        }
    }

    protected void unregisterPresentationDelegate(Intent intent) {
        if (intent.hasExtra("com.sensorberg.android.sdk.intent.messenger")) {
            Messenger messenger = (Messenger)intent.getParcelableExtra("com.sensorberg.android.sdk.intent.messenger");
            this.presentationDelegates.remove(messenger);
        }
    }

    protected void processBluetoothStateMessage(Intent intent) {
        if (intent.hasExtra("com.sensorberg.android.sdk.intent.bluetoothState")) {
            boolean bluetoothOn = intent.getBooleanExtra("com.sensorberg.android.sdk.intent.bluetoothState", true);
            if (bluetoothOn) {
                this.bootstrapper.startScanning();
            } else {
                this.bootstrapper.stopScanning();
            }
        }
    }

    protected void setAdvertisingIdentifier(Intent intent) {
        if (intent.hasExtra("com.sensorberg.android.sdk.message.setAdvertisingIdentifier.advertisingIdentifier")) {
            String advertisingIdentifier = intent.getStringExtra("com.sensorberg.android.sdk.message.setAdvertisingIdentifier.advertisingIdentifier");
            this.platformIdentifier.setAdvertisingIdentifier(advertisingIdentifier);
        }
    }

    public boolean onUnbind(Intent intent) {
        Logger.log.logServiceState("onUnbind");
        return false;
    }

    public void onDestroy() {
        Logger.log.logServiceState("onDestroy");
        if (this.bootstrapper != null) {
            this.bootstrapper.stopScanning();
            this.bootstrapper.saveAllDataBeforeDestroy();
        }
        super.onDestroy();
    }

    @TargetApi(value=14)
    public void onTaskRemoved(Intent rootIntent) {
        this.bootstrapper.saveAllDataBeforeDestroy();
        Logger.log.logServiceState("onTaskRemoved");
        super.onTaskRemoved(rootIntent);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    protected class MessengerList {
        private final Set<Messenger> storage = new HashSet<Messenger>();

        protected MessengerList() {
        }

        public int getSize() {
            return this.storage.size();
        }

        public void add(Messenger replyTo) {
            this.storage.clear();
            this.storage.add(replyTo);
            if (this.storage.size() >= 1) {
                SensorbergService.this.bootstrapper.sentPresentationDelegationTo(this);
            }
        }

        public void remove(Messenger replyTo) {
            this.storage.remove(replyTo);
            this.storage.clear();
            if (this.storage.size() == 0) {
                SensorbergService.this.bootstrapper.sentPresentationDelegationTo(null);
            }
        }

        public void send(BeaconEvent beaconEvent) {
            for (Messenger messenger : this.storage) {
                try {
                    Message message = Message.obtain(null, (int)4);
                    Bundle bundle = new Bundle();
                    bundle.putParcelable("com.sensorberg.android.sdk.message.presentBeaconEvent.beaconEvent", (Parcelable)beaconEvent);
                    message.setData(bundle);
                    messenger.send(message);
                }
                catch (DeadObjectException message) {
                }
                catch (RemoteException e) {
                    SensorbergService.this.logError("something went wrong sending BeaconEvent through Messenger", (Exception)((Object)e));
                }
            }
        }
    }
}

