/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.content.Context;
import android.os.Build;
import java.util.HashMap;
import java.util.Map;

public class PermissionChecker {
    private final Context context;
    private final Map<String, Boolean> permissionCache = new HashMap<String, Boolean>();

    public PermissionChecker(Context context) {
        this.context = context;
    }

    public boolean hasVibratePermission() {
        return this.checkForPermission("android.permission.VIBRATE");
    }

    public boolean hasReadSyncSettingsPermissions() {
        return this.checkForPermission("android.permission.READ_SYNC_SETTINGS");
    }

    public boolean hasLocationPermission() {
        return this.checkForPermission("android.permission.ACCESS_COARSE_LOCATION") || this.checkForPermission("android.permission.ACCESS_FINE_LOCATION");
    }

    private boolean checkForPermission(String permissionIdentifier) {
        if (this.permissionCache.get(permissionIdentifier) != null) {
            return this.permissionCache.get(permissionIdentifier);
        }
        int res = this.context.checkCallingOrSelfPermission(permissionIdentifier);
        boolean value = res == 0;
        this.permissionCache.put(permissionIdentifier, value);
        return value;
    }

    public boolean hasScanPermissionCheckAndroid6() {
        if (Build.VERSION.SDK_INT <= 23) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && this.hasLocationPermission();
    }
}

