/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.resolver;

import android.os.Parcel;
import android.os.Parcelable;
import com.sensorberg.sdk.scanner.ScanEvent;

public final class ResolutionConfiguration
implements Parcelable {
    public int retry;
    public int maxRetries;
    public long millisBetweenRetries;
    private ScanEvent scanEvent;
    public static final Parcelable.Creator<ResolutionConfiguration> CREATOR = new Parcelable.Creator<ResolutionConfiguration>(){

        public ResolutionConfiguration createFromParcel(Parcel source) {
            return new ResolutionConfiguration(source);
        }

        public ResolutionConfiguration[] newArray(int size) {
            return new ResolutionConfiguration[size];
        }
    };

    public ResolutionConfiguration() {
        this.scanEvent = null;
        this.retry = 0;
        this.maxRetries = 0;
        this.millisBetweenRetries = 0L;
    }

    public ResolutionConfiguration(ScanEvent scanEvent) {
        this();
        this.scanEvent = scanEvent;
    }

    public ScanEvent getScanEvent() {
        return this.scanEvent;
    }

    public void setScanEvent(ScanEvent scanEvent) {
        this.scanEvent = scanEvent;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.retry);
        dest.writeInt(this.maxRetries);
        dest.writeLong(this.millisBetweenRetries);
        dest.writeParcelable((Parcelable)this.scanEvent, 0);
    }

    private ResolutionConfiguration(Parcel in) {
        this.retry = in.readInt();
        this.maxRetries = in.readInt();
        this.millisBetweenRetries = in.readLong();
        this.scanEvent = (ScanEvent)in.readParcelable(ScanEvent.class.getClassLoader());
    }

    public boolean canRetry() {
        return this.maxRetries >= this.retry + 1;
    }

    public boolean canTry() {
        return this.maxRetries >= this.retry;
    }
}

