/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.action;

import android.os.Parcel;
import android.os.Parcelable;
import com.sensorberg.sdk.action.ActionType;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Action
implements Parcelable {
    public static final long NO_DELAY = 0L;
    public static final String INTENT_KEY = "com.sensorberg.sdk.Action";
    private final ActionType type;
    private final long delayTime;
    private final UUID uuid;
    private final String payload;

    protected Action(ActionType type, long delayTime, UUID uuid, String payload) {
        this.type = type;
        this.delayTime = delayTime;
        this.uuid = uuid;
        this.payload = payload;
    }

    protected Action(Parcel source) {
        this.type = ActionType.fromId(source.readInt());
        this.delayTime = source.readLong();
        this.uuid = UUID.fromString(source.readString());
        this.payload = source.readString();
    }

    public int describeContents() {
        return 1;
    }

    public void writeToParcel(Parcel destination, int flags) {
        destination.writeInt(this.type.getId());
        destination.writeLong(this.delayTime);
        destination.writeString(this.uuid.toString());
        destination.writeString(this.payload);
    }

    public ActionType getType() {
        return this.type;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public String getPayload() {
        return this.payload;
    }

    public JSONObject getPayloadJSONObject() throws JSONException {
        if (this.payload == null) {
            return null;
        }
        return new JSONObject(this.payload);
    }

    public JSONArray getPayloadJSONArray() throws JSONException {
        if (this.payload == null) {
            return null;
        }
        return new JSONArray(this.payload);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action action = (Action)o;
        return !(this.uuid == null ? action.uuid != null : !this.uuid.equals(action.uuid));
    }

    public int hashCode() {
        return this.uuid != null ? this.uuid.hashCode() : 0;
    }

    public String toString() {
        return "Action(type=" + (Object)((Object)this.getType()) + ", delayTime=" + this.getDelayTime() + ", uuid=" + this.getUuid() + ", payload=" + this.getPayload() + ")";
    }
}

