/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.content.SharedPreferences;
import android.os.Message;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.internal.transport.interfaces.TransportHistoryCallback;
import com.sensorberg.sdk.model.persistence.BeaconAction;
import com.sensorberg.sdk.model.persistence.BeaconScan;
import com.sensorberg.sdk.model.persistence.InternalBeaconAction;
import com.sensorberg.sdk.model.persistence.InternalBeaconScan;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolverListener;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScannerListener;
import com.sensorberg.sdk.settings.SettingsManager;
import com.sensorberg.utils.ListUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class BeaconActionHistoryPublisher
implements ScannerListener,
RunLoop.MessageHandlerCallback {
    private static final int MSG_PUBLISH_HISTORY = 1;
    private static final int MSG_DELETE_ALL_DATA = 6;
    private Clock clock;
    private final RunLoop runloop;
    private final Transport transport;
    private ResolverListener resolverListener = ResolverListener.NONE;
    private final SettingsManager settingsManager;
    private final SharedPreferences sharedPreferences;
    private final Gson gson;
    private Set<InternalBeaconScan> beaconScans = Collections.synchronizedSet(new HashSet());
    private Set<InternalBeaconAction> beaconActions = Collections.synchronizedSet(new HashSet());

    public BeaconActionHistoryPublisher(Transport transport, SettingsManager settingsManager, Clock clock, HandlerManager handlerManager, SharedPreferences sharedPrefs, Gson gson) {
        this.settingsManager = settingsManager;
        this.transport = transport;
        this.clock = clock;
        this.runloop = handlerManager.getBeaconPublisherRunLoop(this);
        this.sharedPreferences = sharedPrefs;
        this.gson = gson;
        this.loadAllData();
    }

    @Override
    public void onScanEventDetected(ScanEvent scanEvent) {
        this.beaconScans.add(InternalBeaconScan.from(scanEvent));
    }

    @Override
    public void handleMessage(Message queueEvent) {
        switch (queueEvent.what) {
            case 1: {
                this.publishHistorySynchronously();
                break;
            }
            case 6: {
                this.deleteAllData();
            }
        }
    }

    private void publishHistorySynchronously() {
        final List<InternalBeaconScan> internalScans = this.notSentBeaconScans();
        final List<InternalBeaconAction> internalActions = this.notSentBeaconActions();
        List<BeaconScan> scans = ListUtils.map(internalScans, InternalBeaconScan.TO_BEACON_SCAN);
        List<BeaconAction> actions = ListUtils.map(internalActions, InternalBeaconAction.TO_BEACON_ACTION);
        if (scans.isEmpty() && actions.isEmpty()) {
            Logger.log.verbose("nothing to report");
            return;
        }
        Logger.log.verbose("reporting " + scans.size() + " scans and " + actions.size() + " actions");
        this.transport.publishHistory(scans, actions, new TransportHistoryCallback(){

            @Override
            public void onSuccess(List<BeaconScan> scanObjectList, List<BeaconAction> actionList) {
                for (InternalBeaconAction internalAction : internalActions) {
                    internalAction.setSentToServerTimestamp(BeaconActionHistoryPublisher.this.clock.now());
                }
                for (InternalBeaconScan internalScan : internalScans) {
                    internalScan.setSentToServerTimestamp(BeaconActionHistoryPublisher.this.clock.now());
                }
                BeaconActionHistoryPublisher.this.removeBeaconScansOlderThan(BeaconActionHistoryPublisher.this.clock.now(), BeaconActionHistoryPublisher.this.settingsManager.getCacheTtl());
                BeaconActionHistoryPublisher.this.removeBeaconActionsOlderThan(BeaconActionHistoryPublisher.this.clock.now(), BeaconActionHistoryPublisher.this.settingsManager.getCacheTtl());
            }

            @Override
            public void onFailure(Exception throwable) {
                Logger.log.logError("not able to publish history", throwable);
            }

            @Override
            public void onInstantActions(List<BeaconEvent> instantActions) {
                BeaconActionHistoryPublisher.this.resolverListener.onResolutionsFinished(instantActions);
            }
        });
    }

    public void publishHistory() {
        this.runloop.add(this.runloop.obtainMessage(1));
    }

    public void onActionPresented(BeaconEvent beaconEvent) {
        this.beaconActions.add(InternalBeaconAction.from(beaconEvent));
    }

    public void deleteAllObjects() {
        this.runloop.sendMessage(6);
    }

    public List<InternalBeaconScan> notSentBeaconScans() {
        return ListUtils.filter(this.beaconScans, new ListUtils.Filter<InternalBeaconScan>(){

            @Override
            public boolean matches(InternalBeaconScan beaconEvent) {
                return beaconEvent.getSentToServerTimestamp() == null;
            }
        });
    }

    private void removeBeaconScansOlderThan(final long timeNow, final long cacheTtl) {
        List<InternalBeaconScan> scansToDelete = ListUtils.filter(this.beaconScans, new ListUtils.Filter<InternalBeaconScan>(){

            @Override
            public boolean matches(InternalBeaconScan beaconEvent) {
                return beaconEvent.getBeaconScan().getCreatedAt() < timeNow - cacheTtl && beaconEvent.getSentToServerTimestamp() != null;
            }
        });
        this.beaconScans.removeAll(scansToDelete);
    }

    public List<InternalBeaconAction> notSentBeaconActions() {
        return ListUtils.filter(this.beaconActions, new ListUtils.Filter<InternalBeaconAction>(){

            @Override
            public boolean matches(InternalBeaconAction internalBeaconAction) {
                return internalBeaconAction.getSentToServerTimestamp() == null;
            }
        });
    }

    private synchronized void removeBeaconActionsOlderThan(final long timeNow, final long cacheTtl) {
        List<InternalBeaconAction> actionsToDelete = ListUtils.filter(this.beaconActions, new ListUtils.Filter<InternalBeaconAction>(){

            @Override
            public boolean matches(InternalBeaconAction beaconEvent) {
                return !beaconEvent.isKeepForever() && beaconEvent.getCreatedAt() < timeNow - cacheTtl && beaconEvent.getSentToServerTimestamp() != null;
            }
        });
        this.beaconActions.removeAll(actionsToDelete);
    }

    public boolean getCountForSuppressionTime(final long lastAllowedPresentationTime, final UUID actionUUID) {
        List<InternalBeaconAction> actionsToKeep = ListUtils.filter(this.beaconActions, new ListUtils.Filter<InternalBeaconAction>(){

            @Override
            public boolean matches(InternalBeaconAction beaconEvent) {
                return beaconEvent.getBeaconAction().getTimeOfPresentation() >= lastAllowedPresentationTime && beaconEvent.getBeaconAction().getActionId().equalsIgnoreCase(actionUUID.toString());
            }
        });
        this.keepForever(actionsToKeep);
        return actionsToKeep.size() > 0;
    }

    private void keepForever(List<InternalBeaconAction> beaconActionSelect) {
        for (InternalBeaconAction internalBeaconAction : beaconActionSelect) {
            internalBeaconAction.setKeepForever(true);
        }
    }

    public boolean getCountForShowOnlyOnceSuppression(final UUID actionUUID) {
        List<InternalBeaconAction> actionsToKeep = ListUtils.filter(this.beaconActions, new ListUtils.Filter<InternalBeaconAction>(){

            @Override
            public boolean matches(InternalBeaconAction internalBeaconAction) {
                return internalBeaconAction.getBeaconAction().getActionId().equalsIgnoreCase(actionUUID.toString());
            }
        });
        this.keepForever(actionsToKeep);
        return actionsToKeep.size() > 0;
    }

    private void loadAllData() {
        String scanJson;
        String actionJson = this.sharedPreferences.getString("com.sensorberg.sdk.InternalBeaconActions", "");
        if (!actionJson.isEmpty()) {
            Type listType = new TypeToken<Set<InternalBeaconAction>>(){}.getType();
            this.beaconActions = Collections.synchronizedSet((Set)this.gson.fromJson(actionJson, listType));
        }
        if (!(scanJson = this.sharedPreferences.getString("com.sensorberg.sdk.InternalBeaconScans", "")).isEmpty()) {
            Type listType = new TypeToken<Set<InternalBeaconScan>>(){}.getType();
            this.beaconScans = Collections.synchronizedSet((Set)this.gson.fromJson(scanJson, listType));
        }
    }

    public void saveAllDataBeforeDestroy() {
        if (this.beaconActions.size() > 0) {
            this.deleteSavedBeaconActionsFromSharedPreferences();
            String actionsJson = this.gson.toJson(this.beaconActions);
            this.sharedPreferences.edit().putString("com.sensorberg.sdk.InternalBeaconActions", actionsJson).apply();
            this.beaconActions = Collections.synchronizedSet(new HashSet());
        }
        if (this.beaconScans.size() > 0) {
            this.deleteSavedBeaconScansFromSharedPreferences();
            String scansJson = this.gson.toJson(this.beaconScans);
            this.sharedPreferences.edit().putString("com.sensorberg.sdk.InternalBeaconScans", scansJson).apply();
            this.beaconScans = Collections.synchronizedSet(new HashSet());
        }
    }

    private void deleteSavedBeaconScansFromSharedPreferences() {
        if (this.sharedPreferences.contains("com.sensorberg.sdk.InternalBeaconScans")) {
            this.sharedPreferences.edit().remove("com.sensorberg.sdk.InternalBeaconScans").apply();
        }
    }

    private void deleteSavedBeaconActionsFromSharedPreferences() {
        if (this.sharedPreferences.contains("com.sensorberg.sdk.InternalBeaconActions")) {
            this.sharedPreferences.edit().remove("com.sensorberg.sdk.InternalBeaconActions").apply();
        }
    }

    public void deleteAllData() {
        this.beaconActions = Collections.synchronizedSet(new HashSet());
        this.beaconScans = Collections.synchronizedSet(new HashSet());
        this.deleteSavedBeaconScansFromSharedPreferences();
        this.deleteSavedBeaconActionsFromSharedPreferences();
    }

    public void setResolverListener(ResolverListener resolverListener) {
        this.resolverListener = resolverListener;
    }
}

