/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.Platform;
import com.sensorberg.sdk.internal.interfaces.ServiceScheduler;
import com.sensorberg.sdk.presenter.LocalBroadcastManager;
import com.sensorberg.sdk.presenter.ManifestParser;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

public class AndroidPlatform
implements Platform {
    @Inject
    protected SharedPreferences settingsPreferences;
    @Inject
    @Named(value="realClock")
    protected Clock clock;
    @Inject
    protected ServiceScheduler mServiceScheduler;
    private final Context context;
    private static boolean actionBroadcastReceiversRegistered;

    @TargetApi(value=18)
    public AndroidPlatform(Context context) {
        this.context = context;
        SensorbergSdk.getComponent().inject(this);
    }

    @Override
    public boolean registerBroadcastReceiver() {
        if (!actionBroadcastReceiversRegistered) {
            List<BroadcastReceiver> broadcastReceiver = this.getBroadcastReceiver();
            if (broadcastReceiver.isEmpty()) {
                return false;
            }
            this.registerBroadcastReceiver(broadcastReceiver);
            actionBroadcastReceiversRegistered = true;
        }
        return true;
    }

    @Override
    public List<BroadcastReceiver> getBroadcastReceiver() {
        return ManifestParser.findBroadcastReceiver(this.context);
    }

    @Override
    public void registerBroadcastReceiver(List<BroadcastReceiver> broadcastReceiver) {
        for (BroadcastReceiver receiver : broadcastReceiver) {
            LocalBroadcastManager.getInstance(this.context).registerReceiver(receiver, new IntentFilter("com.sensorberg.android.PRESENT_ACTION"));
        }
    }
}

