/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.resolver;

import android.os.Message;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.CurrentResolutions;
import com.sensorberg.sdk.resolver.Resolution;
import com.sensorberg.sdk.resolver.ResolutionConfiguration;
import com.sensorberg.sdk.resolver.ResolverConfiguration;
import com.sensorberg.sdk.resolver.ResolverEvent;
import com.sensorberg.sdk.resolver.ResolverListener;
import java.util.ArrayList;
import java.util.List;

public final class Resolver
implements RunLoop.MessageHandlerCallback {
    private final Object listenersMonitor = new Object();
    private final Object resolutionsMonitor = new Object();
    public final ResolverConfiguration configuration;
    private final List<ResolverListener> listeners = new ArrayList<ResolverListener>();
    private final CurrentResolutions currentResolutions = new CurrentResolutions();
    private final Transport transport;
    private final RunLoop runLoop;

    public Resolver(ResolverConfiguration configuration, HandlerManager handlerManager, Transport transport) {
        this.configuration = configuration;
        this.runLoop = handlerManager.getResolverRunLoop(this);
        this.transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResolverListener(ResolverListener listener) {
        Object object = this.listenersMonitor;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    public Resolution createResolution(ResolutionConfiguration resolutionConfiguration) {
        return new Resolution(this, resolutionConfiguration, this.transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message queueEvent) {
        Object object = this.resolutionsMonitor;
        synchronized (object) {
            switch (queueEvent.arg1) {
                case 1: {
                    Resolution resolution = (Resolution)queueEvent.obj;
                    if (this.currentResolutions.contains(resolution)) {
                        Logger.log.beaconResolveState(resolution.configuration.getScanEvent(), "request already running, not stating a new one");
                        return;
                    }
                    this.currentResolutions.add(resolution);
                    resolution.queryServer();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unhandled default case");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResolutionFailed(Resolution resolution, Throwable cause) {
        Object object = this.listenersMonitor;
        synchronized (object) {
            for (ResolverListener listener : this.listeners) {
                listener.onResolutionFailed(resolution, cause);
            }
        }
        this.currentResolutions.remove(resolution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResolutionFinished(Resolution resolution, List<BeaconEvent> beaconEvents) {
        Object object = this.listenersMonitor;
        synchronized (object) {
            for (ResolverListener listener : this.listeners) {
                listener.onResolutionsFinished(beaconEvents);
            }
        }
        this.currentResolutions.remove(resolution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResolverListener(ResolverListener listener) {
        Object object = this.listenersMonitor;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    public void startResolution(Resolution resolution) {
        this.runLoop.add(ResolverEvent.asMessage(1, resolution));
    }

    public void retry(ResolutionConfiguration configuration) {
        Resolution resolution = this.currentResolutions.get(configuration.getScanEvent());
        if (resolution == null) {
            resolution = this.createResolution(configuration);
            Logger.log.beaconResolveState(configuration.getScanEvent(), "creating a new resolution, we have been in the background for too long");
        }
        ++resolution.configuration.retry;
        Logger.log.beaconResolveState(resolution.configuration.getScanEvent(), "performing the retry No." + resolution.configuration.retry);
        resolution.queryServer();
    }
}

