/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.persistence;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScanEventType;

public class BeaconScan {
    public static final String SHARED_PREFS_TAG = "BeaconScans";
    public static final long NO_DATE = Long.MIN_VALUE;
    @Expose
    @SerializedName(value="trigger")
    private int trigger;
    @Expose
    @SerializedName(value="pid")
    private String pid;
    private long sentToServerTimestamp;
    @Expose
    @SerializedName(value="dt")
    private long createdAt;

    public static BeaconScan from(ScanEvent scanEvent) {
        BeaconScan value = new BeaconScan();
        value.setTrigger(scanEvent.isEntry() ? ScanEventType.ENTRY.getMask() : ScanEventType.EXIT.getMask());
        value.setPid(scanEvent.getBeaconId().getPid());
        value.setSentToServerTimestamp(Long.MIN_VALUE);
        value.setCreatedAt(scanEvent.getEventTime());
        return value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeaconScan)) {
            return false;
        }
        BeaconScan other = (BeaconScan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTrigger() != other.getTrigger()) {
            return false;
        }
        String this$pid = this.getPid();
        String other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !this$pid.equals(other$pid)) {
            return false;
        }
        if (this.getSentToServerTimestamp() != other.getSentToServerTimestamp()) {
            return false;
        }
        return this.getCreatedAt() == other.getCreatedAt();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeaconScan;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTrigger();
        String $pid = this.getPid();
        result = result * 59 + ($pid == null ? 0 : $pid.hashCode());
        long $sentToServerTimestamp = this.getSentToServerTimestamp();
        result = result * 59 + (int)($sentToServerTimestamp >>> 32 ^ $sentToServerTimestamp);
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        return result;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public long getSentToServerTimestamp() {
        return this.sentToServerTimestamp;
    }

    public void setSentToServerTimestamp(long sentToServerTimestamp) {
        this.sentToServerTimestamp = sentToServerTimestamp;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }
}

