/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.persistence;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.resolver.BeaconEvent;

public class BeaconAction {
    public static final String SHARED_PREFS_TAG = "BeaconActions";
    public static final long NO_DATE = Long.MIN_VALUE;
    @Expose
    @SerializedName(value="eid")
    private String actionId;
    @Expose
    @SerializedName(value="dt")
    private long timeOfPresentation;
    private long sentToServerTimestamp;
    private long createdAt;
    @Expose
    @SerializedName(value="trigger")
    private int trigger;
    @Expose
    @SerializedName(value="pid")
    private String pid;
    private boolean keepForever;

    public static BeaconAction from(BeaconEvent beaconEvent, Clock clock) {
        BeaconAction value = new BeaconAction();
        value.setActionId(beaconEvent.getAction().getUuid().toString());
        value.setTimeOfPresentation(beaconEvent.getPresentationTime());
        value.setSentToServerTimestamp(Long.MIN_VALUE);
        value.setCreatedAt(clock.now());
        value.setTrigger(beaconEvent.trigger);
        if (beaconEvent.getBeaconId() != null) {
            value.setPid(beaconEvent.getBeaconId().getPid());
        }
        if (beaconEvent.sendOnlyOnce || beaconEvent.getSuppressionTimeMillis() > 0L) {
            value.setKeepForever(true);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeaconAction)) {
            return false;
        }
        BeaconAction other = (BeaconAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$actionId = this.getActionId();
        String other$actionId = other.getActionId();
        if (this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId)) {
            return false;
        }
        if (this.getTimeOfPresentation() != other.getTimeOfPresentation()) {
            return false;
        }
        if (this.getSentToServerTimestamp() != other.getSentToServerTimestamp()) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        if (this.getTrigger() != other.getTrigger()) {
            return false;
        }
        String this$pid = this.getPid();
        String other$pid = other.getPid();
        if (this$pid == null ? other$pid != null : !this$pid.equals(other$pid)) {
            return false;
        }
        return this.isKeepForever() == other.isKeepForever();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeaconAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $actionId = this.getActionId();
        result = result * 59 + ($actionId == null ? 0 : $actionId.hashCode());
        long $timeOfPresentation = this.getTimeOfPresentation();
        result = result * 59 + (int)($timeOfPresentation >>> 32 ^ $timeOfPresentation);
        long $sentToServerTimestamp = this.getSentToServerTimestamp();
        result = result * 59 + (int)($sentToServerTimestamp >>> 32 ^ $sentToServerTimestamp);
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        result = result * 59 + this.getTrigger();
        String $pid = this.getPid();
        result = result * 59 + ($pid == null ? 0 : $pid.hashCode());
        result = result * 59 + (this.isKeepForever() ? 79 : 97);
        return result;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public long getTimeOfPresentation() {
        return this.timeOfPresentation;
    }

    public void setTimeOfPresentation(long timeOfPresentation) {
        this.timeOfPresentation = timeOfPresentation;
    }

    public long getSentToServerTimestamp() {
        return this.sentToServerTimestamp;
    }

    public void setSentToServerTimestamp(long sentToServerTimestamp) {
        this.sentToServerTimestamp = sentToServerTimestamp;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public boolean isKeepForever() {
        return this.keepForever;
    }

    public void setKeepForever(boolean keepForever) {
        this.keepForever = keepForever;
    }
}

