/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.settings;

import android.content.SharedPreferences;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.sensorberg.sdk.settings.SettingsUpdateCallback;

public class Settings {
    @Expose
    @SerializedName(value="cache.objectTTL")
    private long cacheTtl = 2592000000L;
    @Expose
    @SerializedName(value="network.beaconLayoutUpdateInterval")
    private long layoutUpdateInterval = 86400000L;
    @Expose
    @SerializedName(value="presenter.messageDelayWindowLength")
    private long messageDelayWindowLength = 10000L;
    @Expose
    @SerializedName(value="scanner.exitTimeoutMillis")
    private long exitTimeoutMillis = 9000L;
    @Expose
    @SerializedName(value="scanner.foreGroundScanTime")
    private long foreGroundScanTime = 10000L;
    @Expose
    @SerializedName(value="scanner.foreGroundWaitTime")
    private long foreGroundWaitTime = 10000L;
    @Expose
    @SerializedName(value="scanner.backgroundScanTime")
    private long backgroundScanTime = 20000L;
    @Expose
    @SerializedName(value="scanner.backgroundWaitTime")
    private long backgroundWaitTime = 120000L;
    @Expose
    @SerializedName(value="network.millisBetweenRetries")
    private long millisBetweenRetries = 5000L;
    @Expose
    @SerializedName(value="network.maximumResolveRetries")
    private int maxRetries = 3;
    @Expose
    @SerializedName(value="network.historyUploadInterval")
    private long historyUploadInterval = 1800000L;
    @Expose
    @SerializedName(value="scanner.cleanBeaconMapRestartTimeout")
    private long cleanBeaconMapRestartTimeout = 60000L;
    @Expose
    @SerializedName(value="settings.updateTime")
    private long settingsUpdateInterval = 86400000L;
    @Expose
    @SerializedName(value="scanner.restoreBeaconStates")
    private boolean shouldRestoreBeaconStates = true;
    private Long revision = null;

    public Settings() {
    }

    public Settings(SharedPreferences preferences) {
        if (preferences != null) {
            this.exitTimeoutMillis = preferences.getLong("com.sensorberg.preferences.scanner.exitTimeoutMillis", 9000L);
            this.foreGroundScanTime = preferences.getLong("com.sensorberg.preferences.scanner.foreGroundScanTime", 10000L);
            this.foreGroundWaitTime = preferences.getLong("com.sensorberg.preferences.scanner.foreGroundWaitTime", 10000L);
            this.backgroundScanTime = preferences.getLong("com.sensorberg.preferences.scanner.backgroundScanTime", 20000L);
            this.backgroundWaitTime = preferences.getLong("com.sensorberg.preferences.scanner.backgroundWaitTime", 120000L);
            this.cleanBeaconMapRestartTimeout = preferences.getLong("com.sensorberg.preferences.scanner.cleanBeaconMapRestartTimeout", 60000L);
            this.revision = preferences.getLong("com.sensorberg.preferences.settings.revision", Long.MIN_VALUE);
            this.settingsUpdateInterval = preferences.getLong("com.sensorberg.preferences.settings.updateInterval", 86400000L);
            this.maxRetries = preferences.getInt("com.sensorberg.preferences.settings.maxResolveRetries", 3);
            this.millisBetweenRetries = preferences.getLong("com.sensorberg.preferences.settings.timeBetweenResolveRetries", 5000L);
            this.historyUploadInterval = preferences.getLong("com.sensorberg.preferences.settings.timeBetweenHistoryUploads", 1800000L);
            this.layoutUpdateInterval = preferences.getLong("com.sensorberg.preferences.settings.timeBetweenBeaconLayoutUpdates", 1800000L);
            this.shouldRestoreBeaconStates = preferences.getBoolean("com.sensorberg.preferences.settings.restoreBeaconStates", true);
            this.cacheTtl = preferences.getLong("com.sensorberg.preferences.platform.cacheObjectTimeToLive", 2592000000L);
        }
    }

    public Settings(long rev, Settings newSettings, SettingsUpdateCallback settingsUpdateCallback) {
        this.exitTimeoutMillis = newSettings.getExitTimeoutMillis();
        this.foreGroundScanTime = newSettings.getForeGroundScanTime();
        this.foreGroundWaitTime = newSettings.getForeGroundWaitTime();
        this.backgroundScanTime = newSettings.getBackgroundScanTime();
        this.backgroundWaitTime = newSettings.getBackgroundWaitTime();
        this.cleanBeaconMapRestartTimeout = newSettings.getCleanBeaconMapRestartTimeout();
        this.messageDelayWindowLength = newSettings.getMessageDelayWindowLength();
        this.cacheTtl = newSettings.getCacheTtl();
        this.maxRetries = newSettings.getMaxRetries();
        this.millisBetweenRetries = newSettings.getMillisBetweenRetries();
        this.shouldRestoreBeaconStates = newSettings.isShouldRestoreBeaconStates();
        this.revision = rev >= 0L ? Long.valueOf(rev) : null;
        if (newSettings.getHistoryUploadInterval() != this.historyUploadInterval) {
            this.historyUploadInterval = newSettings.getHistoryUploadInterval();
            settingsUpdateCallback.onHistoryUploadIntervalChange(this.historyUploadInterval);
        }
        if (newSettings.getLayoutUpdateInterval() != this.layoutUpdateInterval) {
            this.layoutUpdateInterval = newSettings.getLayoutUpdateInterval();
            settingsUpdateCallback.onSettingsBeaconLayoutUpdateIntervalChange(this.layoutUpdateInterval);
        }
        if (newSettings.getSettingsUpdateInterval() != this.settingsUpdateInterval) {
            this.settingsUpdateInterval = newSettings.getSettingsUpdateInterval();
            settingsUpdateCallback.onSettingsUpdateIntervalChange(this.settingsUpdateInterval);
        }
    }

    public void persistToPreferences(SharedPreferences preferences) {
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            if (this.revision != null) {
                editor.putLong("com.sensorberg.preferences.settings.revision", this.revision.longValue());
            } else {
                editor.remove("com.sensorberg.preferences.settings.revision");
            }
            editor.putLong("com.sensorberg.preferences.scanner.exitTimeoutMillis", this.exitTimeoutMillis);
            editor.putLong("com.sensorberg.preferences.scanner.foreGroundScanTime", this.foreGroundScanTime);
            editor.putLong("com.sensorberg.preferences.scanner.foreGroundWaitTime", this.foreGroundWaitTime);
            editor.putLong("com.sensorberg.preferences.scanner.backgroundScanTime", this.backgroundScanTime);
            editor.putLong("com.sensorberg.preferences.scanner.backgroundWaitTime", this.backgroundWaitTime);
            editor.putBoolean("com.sensorberg.preferences.settings.restoreBeaconStates", this.shouldRestoreBeaconStates);
            editor.putLong("com.sensorberg.preferences.settings.messageDelayWindowLength", this.messageDelayWindowLength);
            editor.putLong("com.sensorberg.preferences.settings.updateInterval", this.settingsUpdateInterval);
            editor.putInt("com.sensorberg.preferences.settings.maxResolveRetries", this.maxRetries);
            editor.putLong("com.sensorberg.preferences.settings.timeBetweenResolveRetries", this.millisBetweenRetries);
            editor.putLong("com.sensorberg.preferences.settings.timeBetweenHistoryUploads", this.historyUploadInterval);
            editor.putLong("com.sensorberg.preferences.settings.timeBetweenBeaconLayoutUpdates", this.layoutUpdateInterval);
            editor.apply();
        }
    }

    public String toString() {
        return "Settings(cacheTtl=" + this.getCacheTtl() + ", layoutUpdateInterval=" + this.getLayoutUpdateInterval() + ", messageDelayWindowLength=" + this.getMessageDelayWindowLength() + ", exitTimeoutMillis=" + this.getExitTimeoutMillis() + ", foreGroundScanTime=" + this.getForeGroundScanTime() + ", foreGroundWaitTime=" + this.getForeGroundWaitTime() + ", backgroundScanTime=" + this.getBackgroundScanTime() + ", backgroundWaitTime=" + this.getBackgroundWaitTime() + ", millisBetweenRetries=" + this.getMillisBetweenRetries() + ", maxRetries=" + this.getMaxRetries() + ", historyUploadInterval=" + this.getHistoryUploadInterval() + ", cleanBeaconMapRestartTimeout=" + this.getCleanBeaconMapRestartTimeout() + ", settingsUpdateInterval=" + this.getSettingsUpdateInterval() + ", shouldRestoreBeaconStates=" + this.isShouldRestoreBeaconStates() + ", revision=" + this.getRevision() + ")";
    }

    public long getCacheTtl() {
        return this.cacheTtl;
    }

    public long getLayoutUpdateInterval() {
        return this.layoutUpdateInterval;
    }

    public long getMessageDelayWindowLength() {
        return this.messageDelayWindowLength;
    }

    public long getExitTimeoutMillis() {
        return this.exitTimeoutMillis;
    }

    public long getForeGroundScanTime() {
        return this.foreGroundScanTime;
    }

    public long getForeGroundWaitTime() {
        return this.foreGroundWaitTime;
    }

    public long getBackgroundScanTime() {
        return this.backgroundScanTime;
    }

    public long getBackgroundWaitTime() {
        return this.backgroundWaitTime;
    }

    public long getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getHistoryUploadInterval() {
        return this.historyUploadInterval;
    }

    public void setHistoryUploadInterval(long historyUploadInterval) {
        this.historyUploadInterval = historyUploadInterval;
    }

    public long getCleanBeaconMapRestartTimeout() {
        return this.cleanBeaconMapRestartTimeout;
    }

    public long getSettingsUpdateInterval() {
        return this.settingsUpdateInterval;
    }

    public boolean isShouldRestoreBeaconStates() {
        return this.shouldRestoreBeaconStates;
    }

    public Long getRevision() {
        return this.revision;
    }

    public static class Builder {
        private Settings settings;

        public Builder(Settings inputSettings) {
            this.settings = inputSettings;
        }

        public Settings build() {
            return this.settings;
        }

        public Builder withExitTimeoutMillis(long timeoutMillis) {
            this.settings.exitTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder withForegroundScanTime(long scanTime) {
            this.settings.foreGroundScanTime = scanTime;
            return this;
        }

        public Builder withForegroundWaitTime(long scanTime) {
            this.settings.foreGroundWaitTime = scanTime;
            return this;
        }

        public Builder withBackgroundScanTime(long scanTime) {
            this.settings.backgroundScanTime = scanTime;
            return this;
        }

        public Builder withBackgroundWaitTime(long scanTime) {
            this.settings.backgroundWaitTime = scanTime;
            return this;
        }
    }
}

