/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.sensorberg.bluetooth.CrashCallBackWrapper;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.PermissionChecker;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;

public class AndroidBluetoothPlatform
implements BluetoothPlatform {
    private final CrashCallBackWrapper crashCallBackWrapper;
    private final BluetoothAdapter bluetoothAdapter;
    private final Context context;
    private boolean leScanRunning = false;
    private PermissionChecker permissionChecker;

    @TargetApi(value=18)
    public AndroidBluetoothPlatform(BluetoothAdapter adapter, CrashCallBackWrapper wrapper, Context ctx) {
        this.context = ctx;
        this.crashCallBackWrapper = wrapper;
        this.bluetoothAdapter = adapter;
        this.permissionChecker = new PermissionChecker(ctx);
    }

    @Override
    public boolean isBluetoothLowEnergyDeviceTurnedOn() {
        return this.isBluetoothLowEnergySupported() && this.bluetoothAdapter.isEnabled();
    }

    @Override
    public boolean isBluetoothLowEnergySupported() {
        return this.bluetoothAdapter != null && Build.VERSION.SDK_INT >= 18 && this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    @Override
    @TargetApi(value=18)
    public void startLeScan(BluetoothAdapter.LeScanCallback scanCallback) {
        if (this.isBluetoothLowEnergySupported() && this.bluetoothAdapter.getState() == 12 && this.permissionChecker.hasScanPermissionCheckAndroid6()) {
            Log.i((String)"bluetooth adapter", (String)Integer.toString(this.bluetoothAdapter.getState()));
            this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this.crashCallBackWrapper);
            this.crashCallBackWrapper.setCallback(scanCallback);
            this.leScanRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=18)
    public void stopLeScan() {
        if (this.isBluetoothLowEnergySupported()) {
            try {
                this.bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)this.crashCallBackWrapper);
            }
            catch (NullPointerException sentBySysteminternally) {
                Logger.log.logError("System bug throwing a NullPointerException internally.", sentBySysteminternally);
            }
            finally {
                this.leScanRunning = false;
                this.crashCallBackWrapper.setCallback(null);
            }
        }
    }

    @Override
    public boolean isLeScanRunning() {
        return this.leScanRunning;
    }
}

