/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Message;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.internal.transport.interfaces.TransportHistoryCallback;
import com.sensorberg.sdk.model.persistence.BeaconAction;
import com.sensorberg.sdk.model.persistence.BeaconScan;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolverListener;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScannerListener;
import com.sensorberg.sdk.settings.SettingsManager;
import com.sensorberg.utils.ListUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class BeaconActionHistoryPublisher
implements ScannerListener,
RunLoop.MessageHandlerCallback {
    private static final int MSG_SCAN_EVENT = 2;
    private static final int MSG_MARK_SCANS_AS_SENT = 3;
    private static final int MSG_PUBLISH_HISTORY = 1;
    private static final int MSG_ACTION = 4;
    private static final int MSG_MARK_ACTIONS_AS_SENT = 5;
    private static final int MSG_DELETE_ALL_DATA = 6;
    private Context context;
    private Clock clock;
    private final RunLoop runloop;
    private final Transport transport;
    private ResolverListener resolverListener = ResolverListener.NONE;
    private final SettingsManager settingsManager;
    private final SharedPreferences sharedPreferences;
    private final Gson gson;
    private Set<BeaconScan> beaconScans = Collections.synchronizedSet(new HashSet());
    private Set<BeaconAction> beaconActions = Collections.synchronizedSet(new HashSet());
    private final Integer beaconScansLock = 5;
    private final Integer beaconActionsLock = 6;

    public BeaconActionHistoryPublisher(Context ctx, Transport transport, SettingsManager settingsManager, Clock clock, HandlerManager handlerManager, SharedPreferences sharedPrefs, Gson gson) {
        this.context = ctx;
        this.settingsManager = settingsManager;
        this.transport = transport;
        this.clock = clock;
        this.runloop = handlerManager.getBeaconPublisherRunLoop(this);
        this.sharedPreferences = sharedPrefs;
        this.gson = gson;
        this.loadAllData();
    }

    @Override
    public void onScanEventDetected(ScanEvent scanEvent) {
        this.runloop.sendMessage(2, scanEvent);
    }

    @Override
    public void handleMessage(Message queueEvent) {
        long now = this.clock.now();
        switch (queueEvent.what) {
            case 2: {
                BeaconScan scan = BeaconScan.from((ScanEvent)queueEvent.obj, this.clock.now());
                this.saveData(scan);
                break;
            }
            case 3: {
                List scans = (List)queueEvent.obj;
                this.markBeaconScansAsSent(scans, now, this.settingsManager.getCacheTtl());
                break;
            }
            case 5: {
                List actions = (List)queueEvent.obj;
                this.markBeaconActionsAsSent(actions, now, this.settingsManager.getCacheTtl());
                break;
            }
            case 1: {
                this.publishHistorySynchronously();
                break;
            }
            case 4: {
                BeaconAction beaconAction = BeaconAction.from((BeaconEvent)queueEvent.obj, this.clock);
                this.saveData(beaconAction);
                break;
            }
            case 6: {
                this.deleteAllData();
            }
        }
    }

    private void publishHistorySynchronously() {
        List<Object> scans = new ArrayList();
        List<Object> actions = new ArrayList();
        try {
            scans = this.notSentBeaconScans();
            actions = this.notSentBeaconActions();
        }
        catch (Exception e) {
            Logger.log.logError("error fetching scans that were not sent from database", e);
        }
        if (scans.isEmpty() && actions.isEmpty()) {
            Logger.log.verbose("nothing to report");
            return;
        }
        this.transport.publishHistory(scans, actions, new TransportHistoryCallback(){

            @Override
            public void onSuccess(List<BeaconScan> scanObjectList, List<BeaconAction> actionList) {
                BeaconActionHistoryPublisher.this.runloop.sendMessage(3, scanObjectList);
                BeaconActionHistoryPublisher.this.runloop.sendMessage(5, actionList);
            }

            @Override
            public void onFailure(Exception throwable) {
                Logger.log.logError("not able to publish history", throwable);
            }

            @Override
            public void onInstantActions(List<BeaconEvent> instantActions) {
                BeaconActionHistoryPublisher.this.resolverListener.onResolutionsFinished(instantActions);
            }
        });
    }

    public void publishHistory() {
        this.runloop.add(this.runloop.obtainMessage(1));
    }

    public void onActionPresented(BeaconEvent beaconEvent) {
        this.runloop.sendMessage(4, beaconEvent);
    }

    public void deleteAllObjects() {
        this.runloop.sendMessage(6);
    }

    private void saveData(BeaconScan beaconScan) {
        this.beaconScans.add(beaconScan);
        Logger.log.verbose("saving scan = " + beaconScan.getProximityUUID() + ", total saved = " + this.beaconScans.size());
    }

    public List<BeaconScan> notSentBeaconScans() {
        return ListUtils.filter(this.beaconScans, new ListUtils.Filter<BeaconScan>(){

            @Override
            public boolean matches(BeaconScan beaconEvent) {
                return beaconEvent.getSentToServerTimestamp2() == Long.MIN_VALUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBeaconScansAsSent(List<BeaconScan> scans, long timeNow, long cacheTtl) {
        if (scans.size() > 0) {
            Integer n = this.beaconScansLock;
            synchronized (n) {
                for (int i = scans.size() - 1; i >= 0; --i) {
                    if (this.beaconScans.contains(scans.get(i))) {
                        this.beaconScans.remove(scans.get(i));
                    }
                    scans.get(i).setSentToServerTimestamp2(timeNow);
                    this.saveData(scans.get(i));
                }
            }
        }
        this.removeBeaconScansOlderThan(timeNow, cacheTtl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBeaconScansOlderThan(final long timeNow, final long cacheTtl) {
        List<BeaconScan> scansToDelete = ListUtils.filter(this.beaconScans, new ListUtils.Filter<BeaconScan>(){

            @Override
            public boolean matches(BeaconScan beaconEvent) {
                return beaconEvent.getCreatedAt() < timeNow - cacheTtl && beaconEvent.getSentToServerTimestamp2() != Long.MIN_VALUE;
            }
        });
        Integer n = this.beaconScansLock;
        synchronized (n) {
            if (scansToDelete.size() > 0) {
                for (int i = scansToDelete.size() - 1; i >= 0; --i) {
                    this.beaconScans.remove(scansToDelete.get(i));
                }
            }
        }
    }

    private void saveData(BeaconAction beaconAction) {
        this.beaconActions.add(beaconAction);
        Logger.log.verbose("saving action = " + beaconAction.getActionId() + ", total saved = " + this.beaconActions.size());
    }

    public List<BeaconAction> notSentBeaconActions() {
        return ListUtils.filter(this.beaconActions, new ListUtils.Filter<BeaconAction>(){

            @Override
            public boolean matches(BeaconAction beaconAction) {
                return beaconAction.getSentToServerTimestamp2() == Long.MIN_VALUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markBeaconActionsAsSent(List<BeaconAction> scans, long timeNow, long cacheTtl) {
        if (scans.size() > 0) {
            Integer n = this.beaconActionsLock;
            synchronized (n) {
                for (int i = scans.size() - 1; i >= 0; --i) {
                    if (this.beaconActions.contains(scans.get(i))) {
                        this.beaconActions.remove(scans.get(i));
                    }
                    scans.get(i).setSentToServerTimestamp2(timeNow);
                    this.saveData(scans.get(i));
                }
            }
        }
        this.removeBeaconActionsOlderThan(timeNow, cacheTtl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeBeaconActionsOlderThan(final long timeNow, final long cacheTtl) {
        List<BeaconAction> actionsToDelete = ListUtils.filter(this.beaconActions, new ListUtils.Filter<BeaconAction>(){

            @Override
            public boolean matches(BeaconAction beaconEvent) {
                return beaconEvent.getCreatedAt() < timeNow - cacheTtl && beaconEvent.getSentToServerTimestamp2() != Long.MIN_VALUE;
            }
        });
        Integer n = this.beaconActionsLock;
        synchronized (n) {
            if (actionsToDelete.size() > 0) {
                for (int i = actionsToDelete.size() - 1; i >= 0; --i) {
                    this.beaconActions.remove(actionsToDelete.get(i));
                }
            }
        }
    }

    public boolean getCountForSuppressionTime(final long lastAllowedPresentationTime, final UUID actionUUID) {
        List<BeaconAction> actionsToKeep = ListUtils.filter(this.beaconActions, new ListUtils.Filter<BeaconAction>(){

            @Override
            public boolean matches(BeaconAction beaconEvent) {
                return beaconEvent.getTimeOfPresentation() >= lastAllowedPresentationTime && beaconEvent.getActionId().equalsIgnoreCase(actionUUID.toString());
            }
        });
        this.keepForever(actionsToKeep);
        return actionsToKeep.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepForever(List<BeaconAction> beaconActionSelect) {
        if (beaconActionSelect.size() > 0) {
            Integer n = this.beaconActionsLock;
            synchronized (n) {
                for (int i = 0; i < beaconActionSelect.size(); ++i) {
                    if (this.beaconActions.contains(beaconActionSelect.get(i))) {
                        this.beaconActions.remove(beaconActionSelect.get(i));
                    }
                    beaconActionSelect.get(i).setKeepForever(true);
                    this.saveData(beaconActionSelect.get(i));
                }
            }
        }
    }

    public boolean getCountForShowOnlyOnceSuppression(final UUID actionUUID) {
        List<BeaconAction> actionsToKeep = ListUtils.filter(this.beaconActions, new ListUtils.Filter<BeaconAction>(){

            @Override
            public boolean matches(BeaconAction beaconEvent) {
                return beaconEvent.getActionId().equalsIgnoreCase(actionUUID.toString());
            }
        });
        this.keepForever(actionsToKeep);
        return actionsToKeep.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllData() {
        String scanJson;
        String actionJson = this.sharedPreferences.getString("BeaconActions", "");
        if (!actionJson.isEmpty()) {
            Type listType = new TypeToken<Set<BeaconAction>>(){}.getType();
            Integer n = this.beaconActionsLock;
            synchronized (n) {
                this.beaconActions = Collections.synchronizedSet((Set)this.gson.fromJson(actionJson, listType));
            }
        }
        if (!(scanJson = this.sharedPreferences.getString("BeaconScans", "")).isEmpty()) {
            Type listType = new TypeToken<Set<BeaconScan>>(){}.getType();
            Integer n = this.beaconScansLock;
            synchronized (n) {
                this.beaconScans = Collections.synchronizedSet((Set)this.gson.fromJson(scanJson, listType));
            }
        }
    }

    public void saveAllData() {
        if (this.beaconActions.size() > 0) {
            this.deleteSavedBeaconActions();
            String actionsJson = this.gson.toJson(this.beaconActions);
            this.sharedPreferences.edit().putString("BeaconActions", actionsJson).apply();
            this.beaconActions = Collections.synchronizedSet(new HashSet());
        }
        if (this.beaconScans.size() > 0) {
            this.deleteSavedBeaconScans();
            String scansJson = this.gson.toJson(this.beaconScans);
            this.sharedPreferences.edit().putString("BeaconScans", scansJson).apply();
            this.beaconScans = Collections.synchronizedSet(new HashSet());
        }
    }

    private void deleteSavedBeaconScans() {
        if (this.sharedPreferences.contains("BeaconScans")) {
            this.sharedPreferences.edit().remove("BeaconScans").apply();
        }
    }

    private void deleteSavedBeaconActions() {
        if (this.sharedPreferences.contains("BeaconActions")) {
            this.sharedPreferences.edit().remove("BeaconActions").apply();
        }
    }

    public void deleteAllData() {
        this.beaconActions = Collections.synchronizedSet(new HashSet());
        this.beaconScans = Collections.synchronizedSet(new HashSet());
        this.deleteSavedBeaconScans();
        this.deleteSavedBeaconActions();
    }

    public void setResolverListener(ResolverListener resolverListener) {
        this.resolverListener = resolverListener;
    }
}

