/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.os.Parcel;
import android.os.Parcelable;
import com.sensorberg.sdk.model.BeaconId;
import com.sensorberg.utils.Objects;

public class ScanEvent
implements Parcelable {
    public static final Parcelable.Creator<ScanEvent> CREATOR = new Parcelable.Creator<ScanEvent>(){

        public ScanEvent createFromParcel(Parcel in) {
            return new ScanEvent(in);
        }

        public ScanEvent[] newArray(int size) {
            return new ScanEvent[size];
        }
    };
    private String hardwareAdress;
    private int initialRssi;
    private int calRssi;
    private final BeaconId beaconId;
    private final long eventTime;
    private final int eventMask;

    protected ScanEvent(BeaconId beaconId, long eventTime, int eventMask) {
        this.beaconId = beaconId;
        this.eventTime = eventTime;
        this.eventMask = eventMask;
    }

    private ScanEvent(Parcel source) {
        this.beaconId = (BeaconId)source.readParcelable(BeaconId.class.getClassLoader());
        this.eventTime = source.readLong();
        this.eventMask = source.readInt();
        this.hardwareAdress = source.readString();
        this.initialRssi = source.readInt();
        this.calRssi = source.readInt();
    }

    public ScanEvent(BeaconId beaconId, long now, int mask, String address, int rssi, int calRssi) {
        this(beaconId, now, mask);
        this.hardwareAdress = address;
        this.initialRssi = rssi;
        this.calRssi = calRssi;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel destination, int flags) {
        destination.writeParcelable((Parcelable)this.beaconId, flags);
        destination.writeLong(this.eventTime);
        destination.writeInt(this.eventMask);
        destination.writeString(this.hardwareAdress);
        destination.writeInt(this.initialRssi);
        destination.writeInt(this.calRssi);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ScanEvent other = (ScanEvent)object;
        return Objects.equals(this.beaconId, other.beaconId) && this.eventMask == other.eventMask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beaconId == null ? 0 : this.beaconId.hashCode());
        result = 31 * result + this.eventMask;
        return result;
    }

    public BeaconId getBeaconId() {
        return this.beaconId;
    }

    public int getEventMask() {
        return this.eventMask;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public int getCalRssi() {
        return this.calRssi;
    }

    public String getHardwareAdress() {
        return this.hardwareAdress;
    }

    public int getInitialRssi() {
        return this.initialRssi;
    }

    public String toString() {
        return "ScanEvent{hardwareAdress='" + this.hardwareAdress + '\'' + ", initialRssi=" + this.initialRssi + ", calRssi=" + this.calRssi + ", beaconId=" + this.beaconId + ", eventTime=" + this.eventTime + ", eventMask=" + this.eventMask + '}';
    }

    public static class Builder {
        private BeaconId beaconId;
        private long eventTime;
        private int eventMask;

        public Builder withBeaconId(BeaconId beaconId) {
            this.beaconId = beaconId;
            return this;
        }

        public Builder withEventTime(long eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public Builder withEventMask(int eventMask) {
            this.eventMask = eventMask;
            return this;
        }

        public ScanEvent build() {
            return new ScanEvent(this.beaconId, this.eventTime, this.eventMask);
        }
    }
}

