/*
 * Decompiled with CFR 0.152.
 */
package com.sensorbergorm.util;

import com.sensorbergorm.dsl.Column;
import com.sensorbergorm.dsl.Table;
import java.lang.reflect.Field;

public class NamingHelper {
    public static String toSQLNameDefault(String camelCased) {
        if (camelCased.equalsIgnoreCase("_id")) {
            return "_id";
        }
        StringBuilder sb = new StringBuilder();
        char[] buf = camelCased.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            boolean isFirstChar;
            char prevChar = i > 0 ? buf[i - 1] : (char)'\u0000';
            char c = buf[i];
            char nextChar = i < buf.length - 1 ? buf[i + 1] : (char)'\u0000';
            boolean bl = isFirstChar = i == 0;
            if (isFirstChar || Character.isLowerCase(c) || Character.isDigit(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (Character.isLetterOrDigit(prevChar)) {
                if (Character.isLowerCase(prevChar)) {
                    sb.append('_').append(c);
                    continue;
                }
                if (nextChar > '\u0000' && Character.isLowerCase(nextChar)) {
                    sb.append('_').append(c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toSQLName(Field field) {
        if (field.isAnnotationPresent(Column.class)) {
            Column annotation = field.getAnnotation(Column.class);
            return annotation.name();
        }
        return NamingHelper.toSQLNameDefault(field.getName());
    }

    public static String toSQLName(Class<?> table) {
        if (table.isAnnotationPresent(Table.class)) {
            Table annotation = table.getAnnotation(Table.class);
            if ("".equals(annotation.name())) {
                return NamingHelper.toSQLNameDefault(table.getSimpleName());
            }
            return annotation.name();
        }
        return NamingHelper.toSQLNameDefault(table.getSimpleName());
    }
}

