/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.sugarorm;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.Expose;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.sensorberg.sdk.model.ISO8601TypeAdapter;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScanEventType;
import com.sensorbergorm.SugarRecord;
import com.sensorbergorm.query.Condition;
import com.sensorbergorm.query.Select;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class SugarScan
extends SugarRecord {
    @Expose
    private long eventTime;
    @Expose
    private boolean isEntry;
    @Expose
    private String proximityUUID;
    @Expose
    private int proximityMajor;
    @Expose
    private int proximityMinor;
    @Expose
    private long sentToServerTimestamp;
    @Expose
    private long sentToServerTimestamp2;
    @Expose
    private long createdAt;

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    public boolean isEntry() {
        return this.isEntry;
    }

    public void setIsEntry(boolean isEntry) {
        this.isEntry = isEntry;
    }

    public String getProximityUUID() {
        return this.proximityUUID;
    }

    public void setProximityUUID(String proximityUUID) {
        this.proximityUUID = proximityUUID;
    }

    public int getProximityMajor() {
        return this.proximityMajor;
    }

    public void setProximityMajor(int proximityMajor) {
        this.proximityMajor = proximityMajor;
    }

    public int getProximityMinor() {
        return this.proximityMinor;
    }

    public void setProximityMinor(int proximityMinor) {
        this.proximityMinor = proximityMinor;
    }

    public int getTrigger() {
        return this.isEntry() ? ScanEventType.ENTRY.getMask() : ScanEventType.EXIT.getMask();
    }

    @Deprecated
    public long getSentToServerTimestamp() {
        return this.sentToServerTimestamp;
    }

    @Deprecated
    public void setSentToServerTimestamp(long sentToServerTimestamp) {
        this.sentToServerTimestamp = sentToServerTimestamp;
    }

    public long getSentToServerTimestamp2() {
        return this.sentToServerTimestamp2;
    }

    public void setSentToServerTimestamp2(long sentToServerTimestamp2) {
        this.sentToServerTimestamp2 = sentToServerTimestamp2;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getPid() {
        return this.getProximityUUID().replace("-", "") + String.format("%1$05d%2$05d", this.getProximityMajor(), this.getProximityMinor());
    }

    public static SugarScan from(ScanEvent scanEvent, long timeNow) {
        SugarScan value = new SugarScan();
        value.setEventTime(scanEvent.getEventTime());
        value.setIsEntry(scanEvent.getEventMask() == ScanEventType.ENTRY.getMask());
        value.setProximityUUID(scanEvent.getBeaconId().getUuid().toString());
        value.setProximityMajor(scanEvent.getBeaconId().getMajorId());
        value.setProximityMinor(scanEvent.getBeaconId().getMinorId());
        value.setSentToServerTimestamp2(Long.MIN_VALUE);
        value.setCreatedAt(timeNow);
        return value;
    }

    public static List<SugarScan> notSentScans() {
        return Select.from(SugarScan.class).where(new Condition[]{Condition.prop((String)"SENT_TO_SERVER_TIMESTAMP2").eq((Object)Long.MIN_VALUE)}).list();
    }

    public static void maskAsSent(List<SugarScan> scans, long timeNow, long cacheTtl) {
        if (scans.size() > 0) {
            for (int i = scans.size() - 1; i >= 0; --i) {
                scans.get(i).setSentToServerTimestamp2(timeNow);
                scans.get(i).save();
            }
        }
        SugarScan.removeAllOlderThan(timeNow, cacheTtl);
    }

    public static void removeAllOlderThan(long timeNow, long cacheTtl) {
        List actionsToDelete = Select.from(SugarScan.class).where(new Condition[]{Condition.prop((String)"CREATED_AT").lt((Object)(timeNow - cacheTtl))}).and(new Condition[]{Condition.prop((String)"SENT_TO_SERVER_TIMESTAMP2").notEq((Object)Long.MIN_VALUE)}).list();
        if (actionsToDelete.size() > 0) {
            for (int i = actionsToDelete.size() - 1; i >= 0; --i) {
                ((SugarScan)((Object)actionsToDelete.get(i))).delete();
            }
        }
    }

    public static class SugarScanObjectTypeAdapter
    extends TypeAdapter<SugarScan> {
        public void write(JsonWriter out, SugarScan value) throws IOException {
            out.beginObject();
            out.name("pid").value(value.getPid());
            out.name("trigger").value((long)value.getTrigger());
            out.name("dt");
            ISO8601TypeAdapter.DATE_ADAPTER.write(out, (Object)new Date(value.getEventTime()));
            out.endObject();
        }

        public SugarScan read(JsonReader in) throws IOException {
            throw new IllegalArgumentException("You must not use this to read a SugarScanObject");
        }
    }
}

