/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import com.sensorberg.SensorbergSdkEventListener;
import com.sensorberg.di.Component;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.SensorbergServiceIntents;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;
import com.sensorberg.sdk.internal.interfaces.Platform;
import com.sensorberg.sdk.receivers.ScannerBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorbergorm.SugarContext;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import net.danlew.android.joda.JodaTimeAndroid;

public class SensorbergSdk
implements Platform.ForegroundStateListener {
    protected final Context context;
    protected boolean presentationDelegationEnabled;
    protected final Messenger messenger = new Messenger((Handler)new IncomingHandler());
    protected static final Set<SensorbergSdkEventListener> listeners = new HashSet<SensorbergSdkEventListener>();
    private static Component component;
    @Inject
    @Named(value="androidBluetoothPlatform")
    protected BluetoothPlatform bluetoothPlatform;

    public SensorbergSdk(Context context, String apiKey) {
        this.context = context;
        SensorbergSdk.setComponent(this.buildComponentAndInject(context));
        SensorbergSdk.getComponent().inject(this);
        SugarContext.init((Context)context);
        JodaTimeAndroid.init((Context)context);
        this.activateService(apiKey);
    }

    public void registerEventListener(SensorbergSdkEventListener listener) {
        if (listener != null) {
            listeners.add(listener);
        }
        if (!listeners.isEmpty() && !this.isPresentationDelegationEnabled()) {
            this.setPresentationDelegationEnabled(true);
        }
    }

    public void unregisterEventListener(SensorbergSdkEventListener listener) {
        listeners.remove(listener);
        if (listeners.isEmpty() && this.isPresentationDelegationEnabled()) {
            this.setPresentationDelegationEnabled(false);
        }
    }

    protected void setPresentationDelegationEnabled(boolean value) {
        this.presentationDelegationEnabled = value;
        if (value) {
            this.registerForPresentationDelegation();
        } else {
            this.unRegisterFromPresentationDelegation();
        }
    }

    protected static void notifyEventListeners(BeaconEvent beaconEvent) {
        for (SensorbergSdkEventListener listener : listeners) {
            listener.presentBeaconEvent(beaconEvent);
        }
    }

    protected void activateService(String apiKey) {
        if (this.bluetoothPlatform.isBluetoothLowEnergySupported()) {
            this.context.startService(SensorbergServiceIntents.getStartServiceIntent(this.context, apiKey));
        }
    }

    public void setResolverBaseURL(URL resolverBaseURL) {
        this.context.startService(SensorbergServiceIntents.getResolverEndpointIntent(this.context, resolverBaseURL));
    }

    public void enableService(Context context, String apiKey) {
        ScannerBroadcastReceiver.setManifestReceiverEnabled(true, context);
        this.activateService(apiKey);
        this.hostApplicationInForeground();
    }

    public void disableService(Context context) {
        context.startService(SensorbergServiceIntents.getShutdownServiceIntent(context));
    }

    @Override
    public void hostApplicationInBackground() {
        Logger.log.applicationStateChanged("hostApplicationInBackground");
        this.context.startService(SensorbergServiceIntents.getAppInBackgroundIntent(this.context));
        this.unRegisterFromPresentationDelegation();
    }

    @Override
    public void hostApplicationInForeground() {
        this.context.startService(SensorbergServiceIntents.getAppInForegroundIntent(this.context));
        if (this.presentationDelegationEnabled) {
            this.registerForPresentationDelegation();
        }
    }

    protected void unRegisterFromPresentationDelegation() {
        this.context.startService(SensorbergServiceIntents.getIntentWithReplyToMessenger(this.context, 101, this.messenger));
    }

    protected void registerForPresentationDelegation() {
        this.context.startService(SensorbergServiceIntents.getIntentWithReplyToMessenger(this.context, 100, this.messenger));
    }

    public void changeAPIToken(String newApiToken) {
        this.context.startService(SensorbergServiceIntents.getApiTokenIntent(this.context, newApiToken));
    }

    public void setAdvertisingIdentifier(String advertisingIdentifier) {
        Intent service = SensorbergServiceIntents.getAdvertisingIdentifierIntent(this.context, advertisingIdentifier);
        this.context.startService(service);
    }

    public void setLogging(boolean enableLogging) {
        this.context.startService(SensorbergServiceIntents.getServiceLoggingIntent(this.context, enableLogging));
    }

    protected Component buildComponentAndInject(Context context) {
        return Component.Initializer.init((Application)context.getApplicationContext());
    }

    public void sendLocationFlagToReceiver(int flagType) {
        Intent intent = new Intent();
        intent.setAction("com.sensorberg.android.sdk.intent.permissionState");
        intent.putExtra("type", flagType);
        this.context.sendBroadcast(intent);
    }

    public boolean isPresentationDelegationEnabled() {
        return this.presentationDelegationEnabled;
    }

    public static Component getComponent() {
        return component;
    }

    public static void setComponent(Component component) {
        SensorbergSdk.component = component;
    }

    static class IncomingHandler
    extends Handler {
        IncomingHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4: {
                    Bundle bundle = msg.getData();
                    bundle.setClassLoader(BeaconEvent.class.getClassLoader());
                    BeaconEvent beaconEvent = (BeaconEvent)bundle.getParcelable("com.sensorberg.android.sdk.message.presentBeaconEvent.beaconEvent");
                    SensorbergSdk.notifyEventListeners(beaconEvent);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

