/*
 * Decompiled with CFR 0.152.
 */
package com.sensorbergorm.util;

import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.util.Log;
import com.sensorbergorm.SugarRecord;
import com.sensorbergorm.dsl.Ignore;
import com.sensorbergorm.dsl.Table;
import com.sensorbergorm.util.ManifestHelper;
import com.sensorbergorm.util.MultiDexHelper;
import com.sensorbergorm.util.NamingHelper;
import com.sensorbergorm.util.SugarConfig;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class ReflectionUtil {
    public static List<Field> getTableFields(Class table) {
        List<Field> fieldList = SugarConfig.getFields(table);
        if (fieldList != null) {
            return fieldList;
        }
        Log.d((String)"Sugar", (String)"Fetching properties");
        ArrayList<Field> typeFields = new ArrayList<Field>();
        ReflectionUtil.getAllFields(typeFields, table);
        ArrayList<Field> toStore = new ArrayList<Field>();
        for (Field field : typeFields) {
            if (field.isAnnotationPresent(Ignore.class) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            toStore.add(field);
        }
        SugarConfig.setFields(table, toStore);
        return toStore;
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        Collections.addAll(fields, type.getDeclaredFields());
        if (type.getSuperclass() != null) {
            fields = ReflectionUtil.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public static void addFieldValueToColumn(ContentValues values, Field column, Object object, Map<Object, Long> entitiesMap) {
        column.setAccessible(true);
        Class<?> columnType = column.getType();
        try {
            String columnName = NamingHelper.toSQLName(column);
            Object columnValue = column.get(object);
            if (columnType.isAnnotationPresent(Table.class)) {
                try {
                    Field field = columnType.getDeclaredField("id");
                    field.setAccessible(true);
                    values.put(columnName, field != null ? String.valueOf(field.get(columnValue)) : "0");
                }
                catch (NoSuchFieldException e) {
                    if (entitiesMap.containsKey(columnValue)) {
                        values.put(columnName, entitiesMap.get(columnValue));
                    }
                }
            } else if (SugarRecord.class.isAssignableFrom(columnType)) {
                values.put(columnName, columnValue != null ? String.valueOf(((SugarRecord)columnValue).getId()) : "0");
            } else if (columnType.equals(Short.class) || columnType.equals(Short.TYPE)) {
                values.put(columnName, (Short)columnValue);
            } else if (columnType.equals(Integer.class) || columnType.equals(Integer.TYPE)) {
                values.put(columnName, (Integer)columnValue);
            } else if (columnType.equals(Long.class) || columnType.equals(Long.TYPE)) {
                values.put(columnName, (Long)columnValue);
            } else if (columnType.equals(Float.class) || columnType.equals(Float.TYPE)) {
                values.put(columnName, (Float)columnValue);
            } else if (columnType.equals(Double.class) || columnType.equals(Double.TYPE)) {
                values.put(columnName, (Double)columnValue);
            } else if (columnType.equals(Boolean.class) || columnType.equals(Boolean.TYPE)) {
                values.put(columnName, (Boolean)columnValue);
            } else if (columnType.equals(BigDecimal.class)) {
                try {
                    values.put(columnName, column.get(object).toString());
                }
                catch (NullPointerException e) {
                    values.putNull(columnName);
                }
            } else if (Timestamp.class.equals(columnType)) {
                try {
                    values.put(columnName, Long.valueOf(((Timestamp)column.get(object)).getTime()));
                }
                catch (NullPointerException e) {
                    values.put(columnName, (Long)null);
                }
            } else if (Date.class.equals(columnType)) {
                try {
                    values.put(columnName, Long.valueOf(((Date)column.get(object)).getTime()));
                }
                catch (NullPointerException e) {
                    values.put(columnName, (Long)null);
                }
            } else if (Calendar.class.equals(columnType)) {
                try {
                    values.put(columnName, Long.valueOf(((Calendar)column.get(object)).getTimeInMillis()));
                }
                catch (NullPointerException e) {
                    values.put(columnName, (Long)null);
                }
            } else if (columnType.equals(byte[].class)) {
                if (columnValue == null) {
                    values.put(columnName, "".getBytes());
                } else {
                    values.put(columnName, (byte[])columnValue);
                }
            } else if (columnValue == null) {
                values.putNull(columnName);
            } else if (columnType.isEnum()) {
                values.put(columnName, ((Enum)columnValue).name());
            } else {
                values.put(columnName, String.valueOf(columnValue));
            }
        }
        catch (IllegalAccessException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
    }

    public static void setFieldValueFromCursor(Cursor cursor, Field field, Object object) {
        field.setAccessible(true);
        try {
            Class<?> fieldType = field.getType();
            String colName = NamingHelper.toSQLName(field);
            int columnIndex = cursor.getColumnIndex(colName);
            if (columnIndex < 0) {
                Log.e((String)"SUGAR", (String)"Invalid colName, you should upgrade database");
                return;
            }
            if (cursor.isNull(columnIndex)) {
                return;
            }
            if (colName.equalsIgnoreCase("id")) {
                long cid = cursor.getLong(columnIndex);
                field.set(object, cid);
            } else if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                field.set(object, cursor.getLong(columnIndex));
            } else if (fieldType.equals(String.class)) {
                String val = cursor.getString(columnIndex);
                field.set(object, val != null && val.equals("null") ? null : val);
            } else if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                field.set(object, cursor.getDouble(columnIndex));
            } else if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                field.set(object, cursor.getString(columnIndex).equals("1"));
            } else if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                field.set(object, cursor.getInt(columnIndex));
            } else if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
                field.set(object, Float.valueOf(cursor.getFloat(columnIndex)));
            } else if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
                field.set(object, cursor.getShort(columnIndex));
            } else if (fieldType.equals(BigDecimal.class)) {
                String val = cursor.getString(columnIndex);
                field.set(object, val != null && val.equals("null") ? null : new BigDecimal(val));
            } else if (fieldType.equals(Timestamp.class)) {
                long l = cursor.getLong(columnIndex);
                field.set(object, new Timestamp(l));
            } else if (fieldType.equals(Date.class)) {
                long l = cursor.getLong(columnIndex);
                field.set(object, new Date(l));
            } else if (fieldType.equals(Calendar.class)) {
                long l = cursor.getLong(columnIndex);
                Calendar c = Calendar.getInstance();
                c.setTimeInMillis(l);
                field.set(object, c);
            } else if (fieldType.equals(byte[].class)) {
                byte[] bytes = cursor.getBlob(columnIndex);
                if (bytes == null) {
                    field.set(object, "".getBytes());
                } else {
                    field.set(object, cursor.getBlob(columnIndex));
                }
            } else if (Enum.class.isAssignableFrom(fieldType)) {
                try {
                    Method valueOf = field.getType().getMethod("valueOf", String.class);
                    String strVal = cursor.getString(columnIndex);
                    Object enumVal = valueOf.invoke(field.getType(), strVal);
                    field.set(object, enumVal);
                }
                catch (Exception e) {
                    Log.e((String)"Sugar", (String)("Enum cannot be read from Sqlite3 database. Please check the type of field " + field.getName()));
                }
            } else {
                Log.e((String)"Sugar", (String)("Class cannot be read from Sqlite3 database. Please check the type of field " + field.getName() + "(" + field.getType().getName() + ")"));
            }
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"field set error", (String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Log.e((String)"field set error", (String)e.getMessage());
        }
    }

    private static Field getDeepField(String fieldName, Class<?> type) throws NoSuchFieldException {
        try {
            Field field = type.getDeclaredField(fieldName);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = type.getSuperclass();
            if (superclass != null) {
                Field field = ReflectionUtil.getDeepField(fieldName, superclass);
                return field;
            }
            throw e;
        }
    }

    public static void setFieldValueForId(Object object, Long value) {
        try {
            Field field = ReflectionUtil.getDeepField("id", object.getClass());
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public static List<Class> getDomainClasses(Context context) {
        ArrayList<Class> domainClasses = new ArrayList<Class>();
        try {
            for (String className : ReflectionUtil.getAllClasses(context)) {
                Class domainClass = ReflectionUtil.getDomainClass(className, context);
                if (domainClass == null) continue;
                domainClasses.add(domainClass);
            }
        }
        catch (IOException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        return domainClasses;
    }

    private static Class getDomainClass(String className, Context context) {
        Class<?> discoveredClass = null;
        try {
            discoveredClass = Class.forName(className, true, context.getClass().getClassLoader());
        }
        catch (Throwable e) {
            String error = e.getMessage() == null ? "getDomainClass " + className + " error" : e.getMessage();
            Log.e((String)"Sugar", (String)error);
        }
        if (discoveredClass != null && (SugarRecord.class.isAssignableFrom(discoveredClass) && !SugarRecord.class.equals(discoveredClass) || discoveredClass.isAnnotationPresent(Table.class)) && !Modifier.isAbstract(discoveredClass.getModifiers())) {
            Log.i((String)"Sugar", (String)("domain class : " + discoveredClass.getSimpleName()));
            return discoveredClass;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllClasses(Context context) throws PackageManager.NameNotFoundException, IOException {
        String packageName = ManifestHelper.getDomainPackageName(context);
        ArrayList<String> classNames = new ArrayList<String>();
        try {
            List<String> allClasses = MultiDexHelper.getAllClasses(context);
            for (String classString : allClasses) {
                if (!classString.startsWith(packageName)) continue;
                classNames.add(classString);
            }
        }
        catch (NullPointerException e) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = classLoader.getResources("");
            while (urls.hasMoreElements()) {
                ArrayList<String> fileNames = new ArrayList<String>();
                String classDirectoryName = urls.nextElement().getFile();
                if (!classDirectoryName.contains("bin") && !classDirectoryName.contains("classes") && !classDirectoryName.contains("retrolambda")) continue;
                File classDirectory = new File(classDirectoryName);
                for (File filePath : classDirectory.listFiles()) {
                    ReflectionUtil.populateFiles(filePath, fileNames, "");
                }
                for (String fileName : fileNames) {
                    if (!fileName.startsWith(packageName)) continue;
                    classNames.add(fileName);
                }
            }
        }
        return classNames;
    }

    private static void populateFiles(File path, List<String> fileNames, String parent) {
        if (path.isDirectory()) {
            for (File newPath : path.listFiles()) {
                if ("".equals(parent)) {
                    ReflectionUtil.populateFiles(newPath, fileNames, path.getName());
                    continue;
                }
                ReflectionUtil.populateFiles(newPath, fileNames, parent + "." + path.getName());
            }
        } else {
            String classSuffix;
            String pathName = path.getName();
            String string = pathName = pathName.endsWith(classSuffix = ".class") ? pathName.substring(0, pathName.length() - classSuffix.length()) : pathName;
            if ("".equals(parent)) {
                fileNames.add(pathName);
            } else {
                fileNames.add(parent + "." + pathName);
            }
        }
    }

    private static String getSourcePath(Context context) throws PackageManager.NameNotFoundException {
        return context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).sourceDir;
    }
}

