/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListUtils {
    public static <INPUT, OUTPUT> List<OUTPUT> map(List<INPUT> inputs, Mapper<INPUT, OUTPUT> mapper) {
        ArrayList<OUTPUT> value = new ArrayList<OUTPUT>();
        for (INPUT object : inputs) {
            OUTPUT mappedObject = mapper.map(object);
            if (mappedObject == null) continue;
            value.add(mappedObject);
        }
        return value;
    }

    public static <MAP_VALUE_TYPE, MAP_KEY_TYPE> List<MAP_VALUE_TYPE> filter(Map<MAP_KEY_TYPE, MAP_VALUE_TYPE> map, Filter<MAP_VALUE_TYPE> filter, MapKeyConverter<MAP_VALUE_TYPE, MAP_KEY_TYPE> mapKeyConverter) {
        ArrayList<MAP_VALUE_TYPE> value = new ArrayList<MAP_VALUE_TYPE>();
        Set<MAP_KEY_TYPE> keySet = map.keySet();
        for (MAP_KEY_TYPE key : keySet) {
            MAP_VALUE_TYPE object = map.get(key);
            if (!filter.matches(object)) continue;
            value.add(object);
            mapKeyConverter.useMapKey(key, object);
        }
        return value;
    }

    public static <K> List<K> filter(List<K> list, Filter<K> filter) {
        ArrayList<K> value = new ArrayList<K>();
        for (K object : list) {
            if (!filter.matches(object)) continue;
            value.add(object);
        }
        return value;
    }

    public static <OBJECT, KEY_TYPE> Map<KEY_TYPE, OBJECT> toMap(List<OBJECT> instantActions, KeyProvider<OBJECT, KEY_TYPE> keyProvider) {
        HashMap<KEY_TYPE, OBJECT> value = new HashMap<KEY_TYPE, OBJECT>();
        for (OBJECT instantAction : instantActions) {
            value.put(keyProvider.map(instantAction), instantAction);
        }
        return value;
    }

    public static interface KeyProvider<OBJECT, KEY_TYPE> {
        public KEY_TYPE map(OBJECT var1);
    }

    public static interface Mapper<INPUT, OUTPUT> {
        public OUTPUT map(INPUT var1);
    }

    public static interface MapKeyConverter<K, S> {
        public void useMapKey(S var1, K var2);
    }

    public static interface Filter<A> {
        public boolean matches(A var1);
    }
}

