/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import com.sensorberg.di.Component;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.SensorbergService;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;
import com.sensorberg.sdk.internal.interfaces.Platform;
import com.sensorberg.sdk.receivers.ScannerBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorbergorm.SugarContext;
import java.io.Serializable;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import net.danlew.android.joda.JodaTimeAndroid;

public class SensorbergApplicationBootstrapper
implements Platform.ForegroundStateListener {
    protected final Context context;
    protected boolean presentationDelegationEnabled;
    protected final Messenger messenger = new Messenger((Handler)new IncomingHandler());
    private static Component component;
    @Inject
    @Named(value="androidBluetoothPlatform")
    BluetoothPlatform bluetoothPlatform;

    public SensorbergApplicationBootstrapper(Context context) {
        this(context, false);
    }

    public SensorbergApplicationBootstrapper(Context context, boolean enablePresentationDelegation) {
        this.context = context;
        this.presentationDelegationEnabled = enablePresentationDelegation;
        SensorbergApplicationBootstrapper.setComponent(this.buildComponentAndInject(context));
        SensorbergApplicationBootstrapper.getComponent().inject(this);
        SugarContext.init((Context)context);
        JodaTimeAndroid.init((Context)context);
    }

    public void activateService() {
        this.activateService(null);
    }

    public void activateService(String apiKey) {
        if (this.bluetoothPlatform.isBluetoothLowEnergySupported()) {
            Intent service = new Intent(this.context, SensorbergService.class);
            service.putExtra("com.sensorberg.android.sdk.intent.startService", 1);
            if (apiKey != null) {
                service.putExtra("com.sensorberg.android.sdk.intent.apiKey", apiKey);
            }
            this.context.startService(service);
        }
    }

    public void presentBeaconEvent(BeaconEvent beaconEvent) {
    }

    public void setResolverBaseURL(URL resolverBaseURL) {
        Intent service = new Intent(this.context, SensorbergService.class);
        service.putExtra("com.sensorberg.android.sdk.intent.generic.type", 105);
        if (resolverBaseURL != null) {
            service.putExtra("com.sensorberg.android.sdk.intent.recolverEndpoint", (Serializable)resolverBaseURL);
        }
        this.context.startService(service);
    }

    public void setPresentationDelegationEnabled(boolean value) {
        this.presentationDelegationEnabled = value;
        if (value) {
            this.registerForPresentationDelegation();
        } else {
            this.unRegisterFromPresentationDelegation();
        }
    }

    public void disableServiceCompletely(Context context) {
        this.sendEmptyMessage(6);
    }

    public void enableService(Context context) {
        this.enableService(context, null);
    }

    public void enableService(Context context, String apiKey) {
        ScannerBroadcastReceiver.setManifestReceiverEnabled(true, context);
        this.activateService(apiKey);
        this.hostApplicationInForeground();
    }

    @Override
    public void hostApplicationInBackground() {
        Logger.log.applicationStateChanged("hostApplicationInBackground");
        this.sendEmptyMessage(2);
        this.unRegisterFromPresentationDelegation();
    }

    @Override
    public void hostApplicationInForeground() {
        this.sendEmptyMessage(1);
        if (this.presentationDelegationEnabled) {
            this.registerForPresentationDelegation();
        }
    }

    protected void sendEmptyMessage(int messageType) {
        Intent service = new Intent(this.context, SensorbergService.class);
        service.putExtra("com.sensorberg.android.sdk.intent.generic.type", messageType);
        this.context.startService(service);
    }

    protected void unRegisterFromPresentationDelegation() {
        this.sendReplyToMessage(101);
    }

    protected void sendReplyToMessage(int messageType) {
        Intent service = new Intent(this.context, SensorbergService.class);
        service.putExtra("com.sensorberg.android.sdk.intent.generic.type", messageType);
        service.putExtra("com.sensorberg.android.sdk.intent.messenger", (Parcelable)this.messenger);
        this.context.startService(service);
    }

    protected void registerForPresentationDelegation() {
        this.sendReplyToMessage(100);
    }

    public void changeAPIToken(String newApiToken) {
        Intent service = new Intent(this.context, SensorbergService.class);
        service.putExtra("com.sensorberg.android.sdk.intent.generic.type", 3);
        service.putExtra("com.sensorberg.android.sdk.message.setApiToken.apiTokenString", newApiToken);
        this.context.startService(service);
    }

    public void setAdvertisingIdentifier(String advertisingIdentifier) {
        Intent service = new Intent(this.context, SensorbergService.class);
        service.putExtra("com.sensorberg.android.sdk.intent.generic.type", 12);
        service.putExtra("com.sensorberg.android.sdk.message.setAdvertisingIdentifier.advertisingIdentifier", advertisingIdentifier);
        this.context.startService(service);
    }

    public void setLogging(boolean enableLogging) {
        Intent service = new Intent(this.context, SensorbergService.class);
        int message = enableLogging ? 104 : 103;
        service.putExtra("com.sensorberg.android.sdk.intent.generic.type", message);
        this.context.startService(service);
    }

    public Component buildComponentAndInject(Context context) {
        return Component.Initializer.init((Application)context.getApplicationContext());
    }

    public static Component getComponent() {
        return component;
    }

    public static void setComponent(Component component) {
        SensorbergApplicationBootstrapper.component = component;
    }

    class IncomingHandler
    extends Handler {
        IncomingHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4: {
                    Bundle bundle = msg.getData();
                    bundle.setClassLoader(BeaconEvent.class.getClassLoader());
                    BeaconEvent beaconEvent = (BeaconEvent)bundle.getParcelable("com.sensorberg.android.sdk.message.presentBeaconEvent.beaconEvent");
                    SensorbergApplicationBootstrapper.this.presentBeaconEvent(beaconEvent);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

