/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.settings;

import android.content.SharedPreferences;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.BeaconHistoryUploadIntervalListener;
import com.sensorberg.sdk.internal.interfaces.MessageDelayWindowLengthListener;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.internal.transport.interfaces.TransportSettingsCallback;
import com.sensorberg.sdk.internal.transport.model.SettingsResponse;
import com.sensorberg.sdk.settings.Settings;
import com.sensorberg.sdk.settings.SettingsUpdateCallback;

public class SettingsManager {
    private final Transport transport;
    private final SharedPreferences preferences;
    private SettingsUpdateCallback settingsUpdateCallback = SettingsUpdateCallback.NONE;
    private MessageDelayWindowLengthListener messageDelayWindowLengthListener = MessageDelayWindowLengthListener.NONE;
    private Settings settings;
    private TransportSettingsCallback transportSettingsCallback = new TransportSettingsCallback(){

        @Override
        public void nothingChanged() {
            Logger.log.logSettingsUpdateState("nothingChanged");
        }

        @Override
        public void onFailure(Exception e) {
            Logger.log.logSettingsUpdateState("onFailure");
            Logger.log.logError("settings update failed", e);
        }

        @Override
        public void onSettingsFound(SettingsResponse networkSettingsResponse) {
            Settings newSettings;
            if (networkSettingsResponse == null) {
                newSettings = new Settings();
                SettingsManager.this.preferences.edit().clear().apply();
            } else {
                newSettings = new Settings(networkSettingsResponse.getRevision(), networkSettingsResponse.getSettings(), SettingsManager.this.settingsUpdateCallback);
            }
            SettingsManager.this.updateSettings(newSettings);
        }
    };
    private BeaconHistoryUploadIntervalListener mBeaconHistoryUploadIntervalListener = new BeaconHistoryUploadIntervalListener(){

        @Override
        public void historyUploadIntervalChanged(Long newHistoryUploadIntervalMillis) {
            if (newHistoryUploadIntervalMillis.longValue() != SettingsManager.this.settings.getHistoryUploadInterval()) {
                SettingsManager.this.settings.setHistoryUploadInterval(newHistoryUploadIntervalMillis);
                SettingsManager.this.settingsUpdateCallback.onHistoryUploadIntervalChange(newHistoryUploadIntervalMillis);
                SettingsManager.this.settings.persistToPreferences(SettingsManager.this.preferences);
            }
        }
    };

    public SettingsManager(Transport trans, SharedPreferences prefs) {
        this.transport = trans;
        this.preferences = prefs;
        this.transport.setBeaconHistoryUploadIntervalListener(this.mBeaconHistoryUploadIntervalListener);
        this.updateSettings(new Settings(prefs));
    }

    private void updateSettings(Settings stgs) {
        this.settings = stgs;
        this.messageDelayWindowLengthListener.setMessageDelayWindowLength(this.getMessageDelayWindowLength());
        this.settings.persistToPreferences(this.preferences);
    }

    public void updateSettingsFromNetwork() {
        this.transport.loadSettings(this.transportSettingsCallback);
    }

    private Settings getSettings() {
        return this.settings;
    }

    public long getExitTimeoutMillis() {
        return this.getSettings().getExitTimeoutMillis();
    }

    public long getCleanBeaconMapRestartTimeout() {
        return this.getSettings().getCleanBeaconMapRestartTimeout();
    }

    public long getForeGroundWaitTime() {
        return this.getSettings().getForeGroundWaitTime();
    }

    public long getForeGroundScanTime() {
        return this.getSettings().getForeGroundScanTime();
    }

    public long getBackgroundWaitTime() {
        return this.getSettings().getBackgroundWaitTime();
    }

    public long getBackgroundScanTime() {
        return this.getSettings().getBackgroundScanTime();
    }

    public long getCacheTtl() {
        return this.getSettings().getCacheTtl();
    }

    public boolean isShouldRestoreBeaconStates() {
        return this.getSettings().isShouldRestoreBeaconStates();
    }

    public int getMaxRetries() {
        return this.getSettings().getMaxRetries();
    }

    public long getMillisBetweenRetries() {
        return this.getSettings().getMillisBetweenRetries();
    }

    public long getLayoutUpdateInterval() {
        return this.getSettings().getLayoutUpdateInterval();
    }

    public long getSettingsUpdateInterval() {
        return this.getSettings().getSettingsUpdateInterval();
    }

    public long getHistoryUploadInterval() {
        return this.getSettings().getHistoryUploadInterval();
    }

    public long getMessageDelayWindowLength() {
        return this.getSettings().getMessageDelayWindowLength();
    }

    public Long getSettingsRevision() {
        return this.getSettings().getRevision();
    }

    public void setSettingsUpdateCallback(SettingsUpdateCallback settingsUpdateCallback) {
        this.settingsUpdateCallback = settingsUpdateCallback;
    }

    public void setMessageDelayWindowLengthListener(MessageDelayWindowLengthListener messageDelayWindowLengthListener) {
        this.messageDelayWindowLengthListener = messageDelayWindowLengthListener;
    }
}

