/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Messenger;
import android.os.Parcelable;
import com.sensorberg.sdk.SensorbergService;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolutionConfiguration;
import java.io.Serializable;
import java.net.URL;

public class SensorbergServiceIntents {
    private SensorbergServiceIntents() {
        throw new IllegalAccessError("Utility class");
    }

    public static Intent getBasicServiceIntent(Context ctx) {
        return new Intent(ctx, SensorbergService.class);
    }

    public static Intent getStartServiceIntent(Context ctx, String apiKey) {
        Intent startIntent = SensorbergServiceIntents.getBasicServiceIntent(ctx);
        startIntent.putExtra("com.sensorberg.android.sdk.intent.startService", 1);
        if (apiKey != null) {
            startIntent.putExtra("com.sensorberg.android.sdk.intent.apiKey", apiKey);
        }
        return startIntent;
    }

    public static Intent getServiceIntentWithMessage(Context ctx, int message) {
        Intent intent = SensorbergServiceIntents.getBasicServiceIntent(ctx);
        intent.putExtra("com.sensorberg.android.sdk.intent.generic.type", message);
        return intent;
    }

    public static Intent getShutdownServiceIntent(Context ctx) {
        return SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 6);
    }

    public static Intent getBeaconLayoutUpdateIntent(Context ctx) {
        return SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 11);
    }

    public static Intent getUpdateSettingsIntent(Context ctx) {
        return SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 102);
    }

    public static Intent getAppInForegroundIntent(Context ctx) {
        return SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 1);
    }

    public static Intent getAppInBackgroundIntent(Context ctx) {
        return SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 2);
    }

    public static Intent getUploadHistoryIntent(Context ctx) {
        return SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 10);
    }

    public static Intent getPingIntent(Context ctx) {
        return SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 7);
    }

    public static Intent getBeaconActionIntent(Context ctx, BeaconEvent beaconEvent, int index) {
        Intent serviceIntent = SensorbergServiceIntents.getBasicServiceIntent(ctx);
        serviceIntent.putExtra("com.sensorberg.android.sdk.intent.generic.type", 1001);
        serviceIntent.putExtra("com.sensorberg.android.sdk.intent.generic.what", (Parcelable)beaconEvent);
        serviceIntent.putExtra("com.sensorberg.android.sdk.intent.generic.index", index);
        return serviceIntent;
    }

    public static Intent getAdvertisingIdentifierIntent(Context ctx, String adId) {
        Intent serviceIntent = SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 12);
        serviceIntent.putExtra("com.sensorberg.android.sdk.message.setAdvertisingIdentifier.advertisingIdentifier", adId);
        return serviceIntent;
    }

    public static Intent getApiTokenIntent(Context ctx, String apiToken) {
        Intent serviceIntent = SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 3);
        serviceIntent.putExtra("com.sensorberg.android.sdk.message.setApiToken.apiTokenString", apiToken);
        return serviceIntent;
    }

    public static Intent getResolverEndpointIntent(Context ctx, URL resolverURL) {
        Intent serviceIntent = SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 105);
        if (resolverURL != null) {
            serviceIntent.putExtra("com.sensorberg.android.sdk.intent.recolverEndpoint", (Serializable)resolverURL);
        }
        return serviceIntent;
    }

    public static Intent getBluetoothMessageIntent(Context ctx, boolean state) {
        Intent serviceIntent = SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 8);
        serviceIntent.putExtra("com.sensorberg.android.sdk.intent.bluetoothState", state);
        return serviceIntent;
    }

    public static Intent getSdkScannerMessageIntent(Context ctx, int scannerEvent) {
        Bundle bundle = new Bundle();
        bundle.putInt("com.sensorberg.sdk.scanner.SDKScanner.SCANNER_EVENT", scannerEvent);
        Intent serviceIntent = SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 9);
        serviceIntent.putExtra("com.sensorberg.android.sdk.intent.generic.what", bundle);
        return serviceIntent;
    }

    public static Intent getRetryResolveScanEventIntent(Context ctx, ResolutionConfiguration configuration) {
        Intent serviceIntent = SensorbergServiceIntents.getServiceIntentWithMessage(ctx, 1002);
        serviceIntent.putExtra("com.sensorberg.android.sdk.intent.generic.what", (Parcelable)configuration);
        return serviceIntent;
    }

    public static Intent getServiceLoggingIntent(Context ctx, boolean enableLogging) {
        int message = enableLogging ? 104 : 103;
        return SensorbergServiceIntents.getServiceIntentWithMessage(ctx, message);
    }

    public static Intent getIntentWithReplyToMessenger(Context ctx, int messageType, Messenger messenger) {
        Intent serviceIntent = SensorbergServiceIntents.getServiceIntentWithMessage(ctx, messageType);
        serviceIntent.putExtra("com.sensorberg.android.sdk.intent.messenger", (Parcelable)messenger);
        return serviceIntent;
    }
}

