/*
 * Decompiled with CFR 0.152.
 */
package com.sensorbergorm.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class MultiDexHelper {
    private static final String EXTRACTED_NAME_EXT = ".classes";
    private static final String EXTRACTED_SUFFIX = ".zip";
    private static final String SECONDARY_FOLDER_NAME = "code_cache" + File.separator + "secondary-dexes";
    private static final String PREFS_FILE = "multidex.version";
    private static final String KEY_DEX_NUMBER = "dex.number";

    private static SharedPreferences getMultiDexPreferences(Context context) {
        return context.getSharedPreferences(PREFS_FILE, Build.VERSION.SDK_INT < 11 ? 0 : 4);
    }

    public static List<String> getSourcePaths(Context context) throws PackageManager.NameNotFoundException, IOException {
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
        File sourceApk = new File(applicationInfo.sourceDir);
        File dexDir = new File(applicationInfo.dataDir, SECONDARY_FOLDER_NAME);
        ArrayList<String> sourcePaths = new ArrayList<String>();
        sourcePaths.add(applicationInfo.sourceDir);
        String extractedFilePrefix = sourceApk.getName() + EXTRACTED_NAME_EXT;
        int totalDexNumber = MultiDexHelper.getMultiDexPreferences(context).getInt(KEY_DEX_NUMBER, 1);
        for (int secondaryNumber = 2; secondaryNumber <= totalDexNumber; ++secondaryNumber) {
            String fileName = extractedFilePrefix + secondaryNumber + EXTRACTED_SUFFIX;
            File extractedFile = new File(dexDir, fileName);
            if (!extractedFile.isFile()) continue;
            sourcePaths.add(extractedFile.getAbsolutePath());
        }
        return sourcePaths;
    }

    public static List<String> getAllClasses(Context context) throws PackageManager.NameNotFoundException, IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        for (String path : MultiDexHelper.getSourcePaths(context)) {
            try {
                DexFile dexfile = path.endsWith(EXTRACTED_SUFFIX) ? DexFile.loadDex((String)path, (String)(path + ".tmp"), (int)0) : new DexFile(path);
                Enumeration dexEntries = dexfile.entries();
                while (dexEntries.hasMoreElements()) {
                    classNames.add((String)dexEntries.nextElement());
                }
            }
            catch (IOException e) {
                throw new IOException("Error at loading dex file '" + path + "'");
            }
        }
        return classNames;
    }
}

