/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.voice.grammar;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class Slot
implements Parcelable {
    private String mName;
    private boolean isOptional = false;
    private List<String> mWordList = new ArrayList<String>();
    public static final Parcelable.Creator<Slot> CREATOR = new Parcelable.Creator<Slot>(){

        public Slot createFromParcel(Parcel in) {
            return new Slot(in);
        }

        public Slot[] newArray(int size) {
            return new Slot[size];
        }
    };

    public Slot(String name) {
        this.mName = name;
    }

    public Slot(String name, boolean optional) {
        this.mName = name;
        this.isOptional = optional;
    }

    public Slot(String name, boolean optional, List<String> wordList) {
        this.mName = name;
        this.isOptional = optional;
        this.mWordList = wordList;
    }

    protected Slot(Parcel in) {
        this.mName = in.readString();
        this.isOptional = in.readByte() != 0;
        this.mWordList = in.createStringArrayList();
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setOptional(boolean optional) {
        this.isOptional = optional;
    }

    public boolean getOptional() {
        return this.isOptional;
    }

    public void addWord(String Word) {
        this.mWordList.add(Word);
    }

    public void addWordsArray(String[] Words) {
        for (String word : Words) {
            this.mWordList.add(word);
        }
    }

    public List<String> getWordList() {
        return this.mWordList;
    }

    public boolean deleteWord(String deleteSlotWord) {
        return this.mWordList.remove(deleteSlotWord);
    }

    public String toOptionalString() {
        if (this.isOptional) {
            return "[<" + this.mName + ">]";
        }
        return "<" + this.mName + ">";
    }

    public String toString() {
        StringBuilder slot = new StringBuilder();
        slot.append("<").append(this.mName).append(">:");
        int slotLength = this.mWordList.size();
        if (slotLength == 0) {
            return this.mName;
        }
        slot.append(this.mWordList.get(0));
        if (slotLength > 1) {
            for (int i = 1; i < slotLength; ++i) {
                slot.append("|").append(this.mWordList.get(i));
            }
        }
        slot.append(";\n");
        return slot.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeByte((byte)(this.isOptional ? 1 : 0));
        dest.writeStringList(this.mWordList);
    }
}

