package com.segway.robot.algo.dts;

public interface PersonTrackingWithTrajectoryListener {
    /**
     * This method is called every time when the current tracking is end.
     *
     * @param person the tracked person or null.
     */
    void onPersonTrackingWithTrajectoryResult(DTSPerson person, FollowTrajectory followTrajectory);

    /**
     * This method is called when an error is occurred while tracking
     * Timeout is one of the most common error
     *
     * @param errorCode code of error
     * @param message   message of error
     */
    void onPersonTrackingWithTrajectoryError(int errorCode, String message);

}
