/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.sdk.base.time.StampedData;

public class RelativePoint3DF
implements StampedData,
Parcelable {
    private final long mTimeStamp;
    private final float mDistance;
    private final float mTheta;
    private final float mPitch;
    public static final Parcelable.Creator<RelativePoint3DF> CREATOR = new Parcelable.Creator<RelativePoint3DF>(){

        public RelativePoint3DF createFromParcel(Parcel in) {
            return new RelativePoint3DF(in);
        }

        public RelativePoint3DF[] newArray(int size) {
            return new RelativePoint3DF[size];
        }
    };

    public RelativePoint3DF(float distance, float theta, float pitch, long timestamp) {
        this.mDistance = distance;
        this.mTheta = theta;
        this.mPitch = pitch;
        this.mTimeStamp = timestamp;
    }

    protected RelativePoint3DF(Parcel in) {
        this.mTimeStamp = in.readLong();
        this.mDistance = in.readFloat();
        this.mTheta = in.readFloat();
        this.mPitch = in.readFloat();
    }

    public float getmDistance() {
        return this.mDistance;
    }

    public float getmTheta() {
        return this.mTheta;
    }

    public float getPitch() {
        return this.mPitch;
    }

    public long getTimestamp() {
        return this.mTimeStamp;
    }

    public long diff(StampedData source) {
        if (source == null) {
            throw new IllegalArgumentException("diff source is null");
        }
        return source.getTimestamp() - this.getTimestamp();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStamp);
        dest.writeFloat(this.mDistance);
        dest.writeFloat(this.mTheta);
        dest.writeFloat(this.mPitch);
    }

    public String toString() {
        return "RelativePoint3DF{mTimeStamp=" + this.mTimeStamp + ", mDistance=" + this.mDistance + ", mTheta=" + this.mTheta + ", mPitch=" + this.mPitch + '}';
    }
}

