/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo.tf;

import android.os.Parcel;
import android.os.Parcelable;

public final class MathUtils
implements Parcelable {
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float E = (float)Math.E;
    private static final int SIN_BITS = 14;
    private static final int SIN_MASK = 16383;
    private static final int SIN_COUNT = 16384;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 2607.5945f;
    private static final float degToIndex = 45.511112f;
    public static final float radiansToDegrees = 57.295776f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final Parcelable.Creator<MathUtils> CREATOR = new Parcelable.Creator<MathUtils>(){

        public MathUtils createFromParcel(Parcel in) {
            return new MathUtils(in);
        }

        public MathUtils[] newArray(int size) {
            return new MathUtils[size];
        }
    };
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double CEIL = 0.9999999;
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_ROUND = 16384.5;

    protected MathUtils(Parcel in) {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
    }

    public static float sin(float radians) {
        return Sin.table[(int)(radians * 2607.5945f) & 0x3FFF];
    }

    public static float cos(float radians) {
        return Sin.table[(int)((radians + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float atan2(float y, float x) {
        if (x == 0.0f) {
            if (y > 0.0f) {
                return 1.5707964f;
            }
            if (y == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float z = y / x;
        if (Math.abs(z) < 1.0f) {
            float atan = z / (1.0f + 0.28f * z * z);
            if (x < 0.0f) {
                return atan + (y < 0.0f ? (float)(-Math.PI) : (float)Math.PI);
            }
            return atan;
        }
        float atan = 1.5707964f - z / (z * z + 0.28f);
        return y < 0.0f ? atan - (float)Math.PI : atan;
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private static class Sin {
        static final float[] table;

        private Sin() {
        }

        static {
            int i;
            table = new float[16384];
            for (i = 0; i < 16384; ++i) {
                Sin.table[i] = (float)Math.sin(((float)i + 0.5f) / 16384.0f * ((float)Math.PI * 2));
            }
            for (i = 0; i < 360; i += 90) {
                Sin.table[(int)((float)i * 45.511112f) & 0x3FFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
            }
        }
    }
}

