/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo.dts;

import android.os.Parcel;
import android.os.Parcelable;

public class PersonTrackingProfile
implements Parcelable {
    int mTrackingFps = 15;
    int mPoseFps = 3;
    float mPlannerTolerance = 2.5f;
    boolean mUseUltraSonic = false;
    public static final Parcelable.Creator<PersonTrackingProfile> CREATOR = new Parcelable.Creator<PersonTrackingProfile>(){

        public PersonTrackingProfile createFromParcel(Parcel in) {
            return new PersonTrackingProfile(in);
        }

        public PersonTrackingProfile[] newArray(int size) {
            return new PersonTrackingProfile[size];
        }
    };

    public PersonTrackingProfile(int trackingFps, int poseFps, float plannerTolerance, boolean useUltraSonic) {
        this.mTrackingFps = trackingFps;
        this.mPoseFps = poseFps;
        this.mPlannerTolerance = plannerTolerance;
        this.mUseUltraSonic = useUltraSonic;
    }

    public PersonTrackingProfile(int poseFps, float plannerTolerance) {
        this.mPoseFps = poseFps;
        this.mPlannerTolerance = plannerTolerance;
        this.mUseUltraSonic = true;
    }

    public PersonTrackingProfile(int poseFps, float plannerTolerance, boolean useUltraSonic) {
        this.mPoseFps = poseFps;
        this.mPlannerTolerance = plannerTolerance;
        this.mUseUltraSonic = useUltraSonic;
    }

    protected PersonTrackingProfile(Parcel in) {
        this.mTrackingFps = in.readInt();
        this.mPoseFps = in.readInt();
        this.mPlannerTolerance = in.readFloat();
        this.mUseUltraSonic = in.readByte() != 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTrackingFps);
        dest.writeInt(this.mPoseFps);
        dest.writeFloat(this.mPlannerTolerance);
        dest.writeByte((byte)(this.mUseUltraSonic ? 1 : 0));
    }

    public int describeContents() {
        return 0;
    }

    public int getPoseFps() {
        return this.mPoseFps;
    }

    public float getPlannerTolerance() {
        return this.mPlannerTolerance;
    }

    public void setPoseFps(int expectedPoseFps) {
        this.mPoseFps = expectedPoseFps;
    }

    public void setPlannerTolerance(float expectedPlannerTolerance) {
        this.mPlannerTolerance = expectedPlannerTolerance;
    }

    public String toString() {
        return "PersonTrackingProfile{mTrackingFps=" + this.mTrackingFps + ", mPoseFps=" + this.mPoseFps + ", mPlannerTolerance=" + this.mPlannerTolerance + ", mUseUltraSonic=" + this.mUseUltraSonic + '}';
    }

    public void setUseUltraSonic(boolean mUseUltraSonic) {
        this.mUseUltraSonic = mUseUltraSonic;
    }

    public boolean isUseUltraSonic() {
        return this.mUseUltraSonic;
    }
}

