/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.sdk.base.time.StampedData;

public class Point2DF
implements StampedData,
Parcelable {
    protected long mTimeStamp;
    protected float mX;
    protected float mY;
    public static final Parcelable.Creator<Point2DF> CREATOR = new Parcelable.Creator<Point2DF>(){

        public Point2DF createFromParcel(Parcel in) {
            return new Point2DF(in);
        }

        public Point2DF[] newArray(int size) {
            return new Point2DF[size];
        }
    };

    public Point2DF(float x, float y, long timeStamp) {
        this.mX = x;
        this.mY = y;
        this.mTimeStamp = timeStamp;
    }

    protected Point2DF(Parcel in) {
        this.mTimeStamp = in.readLong();
        this.mX = in.readFloat();
        this.mY = in.readFloat();
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public long getTimestamp() {
        return this.mTimeStamp;
    }

    public float distanceTo(Point2DF targetPoint) {
        return (float)Math.sqrt(Math.pow(this.getX() - targetPoint.getX(), 2.0) + Math.pow(this.getY() - targetPoint.getY(), 2.0));
    }

    public long diff(StampedData source) {
        if (source == null) {
            throw new IllegalArgumentException("diff source is null");
        }
        return source.getTimestamp() - this.getTimestamp();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStamp);
        dest.writeFloat(this.mX);
        dest.writeFloat(this.mY);
    }

    public String toString() {
        return "Point2DF{mTimeStamp=" + this.mTimeStamp + ", mX=" + this.mX + ", mY=" + this.mY + '}';
    }
}

