package com.segway.robot.algo.dts;

/**
 * Callback interface for being notified that a new state of person tracking with planner
 */
public interface PersonTrackingWithPlannerListener {
    /**
     * This method is called every time when the current tracking is end.
     *
     * @param person the tracked person or null.
     */
    void onPersonTrackingWithPlannerResult(DTSPerson person, BaseControlCommand baseControlCommand);

    /**
     * This method is called when an error is occurred while tracking
     * Timeout is one of the most common error
     *
     * @param errorCode code of error
     * @param message   message of error
     */
    void onPersonTrackingWithPlannerError(int errorCode, String message);

}
