package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

/**
 * Created by tangchu on 2017/1/13.
 */

public class RelativePoint3DF implements StampedData, Parcelable{
    private final long mTimeStamp;
    private final float mDistance;
    private final float mTheta;
    private final float mPitch;

    public RelativePoint3DF(float distance, float theta, float pitch, long timestamp) {
        this.mDistance = distance;
        this.mTheta = theta;
        this.mPitch = pitch;
        this.mTimeStamp = timestamp;
    }

    protected RelativePoint3DF(Parcel in) {
        mTimeStamp = in.readLong();
        mDistance = in.readFloat();
        mTheta = in.readFloat();
        mPitch = in.readFloat();
    }

    public static final Creator<RelativePoint3DF> CREATOR = new Creator<RelativePoint3DF>() {
        @Override
        public RelativePoint3DF createFromParcel(Parcel in) {
            return new RelativePoint3DF(in);
        }

        @Override
        public RelativePoint3DF[] newArray(int size) {
            return new RelativePoint3DF[size];
        }
    };

    public float getmDistance() {
        return mDistance;
    }

    public float getmTheta() {
        return mTheta;
    }

    public float getPitch() {
        return mPitch;
    }

    @Override
    public long getTimestamp() {
        return mTimeStamp;
    }

    @Override
    public long diff(StampedData source) {
        if (source == null) {
            throw new IllegalArgumentException("diff source is null");
        }
        return source.getTimestamp() - getTimestamp();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimeStamp);
        dest.writeFloat(mDistance);
        dest.writeFloat(mTheta);
        dest.writeFloat(mPitch);
    }

    @Override
    public String toString() {
        return "RelativePoint3DF{" +
                "mTimeStamp=" + mTimeStamp +
                ", mDistance=" + mDistance +
                ", mTheta=" + mTheta +
                ", mPitch=" + mPitch +
                '}';
    }
}
