package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * This class provides a 3x3 float Matrix {@link Matrix3F}.
 */

public class Matrix3F implements Parcelable{
    public float[][] matrix = new float[3][3];

    public Matrix3F() {
    }

    protected Matrix3F(Parcel in) {
        matrix[0][0] = in.readFloat();
        matrix[0][1] = in.readFloat();
        matrix[0][2] = in.readFloat();
        matrix[1][0] = in.readFloat();
        matrix[1][1] = in.readFloat();
        matrix[1][2] = in.readFloat();
        matrix[2][0] = in.readFloat();
        matrix[2][1] = in.readFloat();
        matrix[2][2] = in.readFloat();
    }

    public static final Creator<Matrix3F> CREATOR = new Creator<Matrix3F>() {
        @Override
        public Matrix3F createFromParcel(Parcel in) {
            return new Matrix3F(in);
        }

        @Override
        public Matrix3F[] newArray(int size) {
            return new Matrix3F[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(matrix[0][0]);
        dest.writeFloat(matrix[0][1]);
        dest.writeFloat(matrix[0][2]);
        dest.writeFloat(matrix[1][0]);
        dest.writeFloat(matrix[1][1]);
        dest.writeFloat(matrix[1][2]);
        dest.writeFloat(matrix[2][0]);
        dest.writeFloat(matrix[2][1]);
        dest.writeFloat(matrix[2][2]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 3; i ++) {
            sb.append("[ ");
            for (int j = 0; j < 3; j++) {
                sb.append(matrix[i][j]).append(' ');
            }
            sb.append("]\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void copyFrom(float[][] src) {
        if (src.length != 3 || src[0].length != 3 || src[1].length != 3 || src[2].length != 3) {
            throw new IllegalArgumentException("the matrix should be 3 x 3");
        }

        for (int i = 0; i < 3; i++) {
            for (int j = 0; j < 3; j++) {
                matrix[i][j] = src[i][j];
            }
        }
    }
}
