package com.segway.robot.algo.generaldts;

/**
 * Callback interface for being notified that a new state of GeneralDts
 */
public interface GeneralTrackingListener {
    /**
     * This method is called every time when the current tracking is end.
     *
     * @param object
     */
    void onObjectTrackingResult(DTSObject object);

    /**
     * This method is called when an error occurred while tracking
     * Timeout is one of the most common error
     *
     * @param errorCode code of error
     * @param message   message of error
     */
    void onObjectTrackingError(int errorCode, String message);
}
