package com.segway.robot.algo;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

import java.nio.ByteBuffer;

/**
 * Created by ark338 on 2017/2/21.
 */

public class OccupancyGridMap2D implements StampedData, Parcelable{
    public static final int PROBABILITY_UNKNOW = -1;
    public static final int PROBABILITY_PERSON = -2;

    private ByteBuffer mMapBuffer;
    private long mTimestamp;
    private Pose2D mOdometryPose;
    private RectF mBoundary;
    private float mResolution;

    public OccupancyGridMap2D(ByteBuffer mapBuffer, long timestamp, Pose2D odometryPose, RectF boundary, float resolution) {
        mMapBuffer = mapBuffer;
        mTimestamp = timestamp;
        mOdometryPose = odometryPose;
        mBoundary = boundary;
        mResolution = resolution;
    }

    protected OccupancyGridMap2D(Parcel in) {
        mTimestamp = in.readLong();
        mBoundary = in.readParcelable(RectF.class.getClassLoader());
        mResolution = in.readFloat();
    }

    public static final Creator<OccupancyGridMap2D> CREATOR = new Creator<OccupancyGridMap2D>() {
        @Override
        public OccupancyGridMap2D createFromParcel(Parcel in) {
            return new OccupancyGridMap2D(in);
        }

        @Override
        public OccupancyGridMap2D[] newArray(int size) {
            return new OccupancyGridMap2D[size];
        }
    };

    Pose2D getOdometryPose() {
        return mOdometryPose;
    }

    public ByteBuffer getMapBuffer() {
        return mMapBuffer;
    }

    public RectF getBoundary() {
        return mBoundary;
    }

    public float getResolution() {
        return mResolution;
    }

    @Override
    public long getTimestamp() {
        return mTimestamp;
    }

    @Override
    public long diff(StampedData source) {
        return source.getTimestamp() - getTimestamp();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimestamp);
        dest.writeParcelable(mBoundary, flags);
        dest.writeFloat(mResolution);
    }

    @Override
    public String toString() {
        return "OccupancyGridMap2D:" +
                " mTimestamp=" + mTimestamp +
                " mOdometryPose=" + mOdometryPose +
                " mBoundary=" + mBoundary +
                " mResolution=" + mResolution;
    }
}
