package com.segway.robot.algo.dts;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.algo.CubeF;
import com.segway.robot.algo.Pose2D;

/**
 * DTSPerson is a person detected by the DTS module
 */
public class DTSPerson extends Person {
    private int mType;
    private float mConfidence;
    private Rect mDrawingRect;
    private Pose2D mRobotPose;
    private float mTheta;
    private float mPitch;
    private float mDistance;
    private int mPosRecIdx;
    private float mPosRecScore;

    public DTSPerson(float x, float y, float z, CubeF bound, int id, int type, float confidence,
                     Rect drawingRect, Pose2D robotPose, float theta, float pitch, float distance,
                     long timeStamp,
                     int posRecIdx, float posRecScore) {
        super(x, y, z, bound, id, timeStamp);
        mType = type;
        mConfidence = confidence;
        mDrawingRect = drawingRect;
        mRobotPose = robotPose;
        mTheta = theta;
        mPitch = pitch;
        mDistance = distance;
        mPosRecIdx = posRecIdx;
        mPosRecScore = posRecScore;
    }
    public DTSPerson(float x, float y, float z, CubeF bound, int id, int type, float confidence,
                     Rect drawingRect, Pose2D robotPose, float theta, float pitch, float distance,
                     long timeStamp) {
        super(x, y, z, bound, id, timeStamp);
        mType = type;
        mConfidence = confidence;
        mDrawingRect = drawingRect;
        mRobotPose = robotPose;
        mTheta = theta;
        mPitch = pitch;
        mDistance = distance;
        mPosRecIdx = -1;
        mPosRecScore = -1;
    }
    /**
     * Get the type of the person
     * This method is incomplete and always return 0
     *
     * @return
     */
    public int getType() {
        return mType;
    }

    /**
     * Get the confidence of the person
     *
     * @return confidence of the person
     */
    public float getConfidence() {
        return mConfidence;
    }

    /**
     * Get the drawing rect of the person
     * Drawing rect describe the drawing bound of the person in the picture
     * The max width and height of drawing rect is 640 and 480
     *
     * @return
     */
    public Rect getDrawingRect() {
        return mDrawingRect;
    }

    /**
     * Get the robot pose at this time
     *
     * @return Robot pose
     */
    public Pose2D getRobotPose() {
        return mRobotPose;
    }

    /**
     * Get the yaw angle from robot to the person
     *
     * @return the yaw angle form robot to the person
     */
    public float getTheta() {
        return mTheta;
    }

    /**
     * Get the pitch angle from robot to the person
     *
     * @return the pitch angle from robot to the person
     */
    public float getPitch() {
        return mPitch;
    }

    /**
     * Get the distance from robot to the center of the person
     *
     * @return the distance from robot to the center of the person
     */
    public float getDistance() {
        return mDistance;
    }

    /**
     *get the index of pos recognition result
     * @return the index of pos recognition result
     */
    public int getPosRecIndex() {
        return mPosRecIdx;
    }

    /**
     *get the confidence of the pos recognition result
     * @return the confidence of the pos recognition result
     */
    public float getPosRecScore() {
        return mPosRecScore;
    }

    public static final Parcelable.Creator<DTSPerson> CREATOR = new Parcelable.Creator<DTSPerson>() {
        @Override
        public DTSPerson createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            float x = in.readFloat();
            float y = in.readFloat();
            float z = in.readFloat();
            CubeF cubeF = in.readParcelable(CubeF.class.getClassLoader());
            int id = in.readInt();
            int type = in.readInt();
            float confidence = in.readFloat();
            Rect rect = in.readParcelable(Rect.class.getClassLoader());
            Pose2D pose = in.readParcelable(Pose2D.class.getClassLoader());
            float theta = in.readFloat();
            float pitch = in.readFloat();
            float distance = in.readFloat();
            int recId = in.readInt();
            float score = in.readFloat();

            return new DTSPerson(x, y, z, cubeF, id, type, confidence,
                    rect, pose, theta, pitch, distance, timestamp, recId, score);
        }

        @Override
        public DTSPerson[] newArray(int size) {
            return new DTSPerson[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimeStamp);
        dest.writeFloat(mX);
        dest.writeFloat(mY);
        dest.writeFloat(mZ);
        dest.writeParcelable(mBound, flags);
        dest.writeInt(mId);
        dest.writeInt(mType);
        dest.writeFloat(mConfidence);
        dest.writeParcelable(mDrawingRect, flags);
        dest.writeParcelable(mRobotPose, flags);
        dest.writeFloat(mTheta);
        dest.writeFloat(mPitch);
        dest.writeFloat(mDistance);
        dest.writeInt(mPosRecIdx);
        dest.writeFloat(mPosRecScore);
    }

    @Override
    public String toString() {
        return "DTSPerson{" +
                "mType=" + mType +
                ", mConfidence=" + mConfidence +
                ", mDrawingRect=" + mDrawingRect +
                ", mRobotPose=" + mRobotPose +
                ", mTheta=" + mTheta +
                ", mPitch=" + mPitch +
                ", mDistance=" + mDistance +
                ", mPosRecIdx=" + mPosRecIdx +
                ", mPosRecScore=" + mPosRecScore +
                '}';
    }
}
