/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.Point2DF;

public class Pose2D
extends Point2DF {
    private final float mTheta;
    private final float mLinearVelocity;
    private final float mAngularVelocity;
    public static final Parcelable.Creator<Pose2D> CREATOR = new Parcelable.Creator<Pose2D>(){

        public Pose2D createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            float x = in.readFloat();
            float y = in.readFloat();
            float theta = in.readFloat();
            float linearVelocity = in.readFloat();
            float angularVelocity = in.readFloat();
            return new Pose2D(x, y, theta, linearVelocity, angularVelocity, timestamp);
        }

        public Pose2D[] newArray(int size) {
            return new Pose2D[size];
        }
    };

    public Pose2D(float x, float y, float theta, float linearVelocity, float angularVelocity, long timeStamp) {
        super(x, y, timeStamp);
        this.mTheta = theta;
        this.mLinearVelocity = linearVelocity;
        this.mAngularVelocity = angularVelocity;
    }

    public float getTheta() {
        return this.mTheta;
    }

    public float getLinearVelocity() {
        return this.mLinearVelocity;
    }

    public float getAngularVelocity() {
        return this.mAngularVelocity;
    }

    public String toString() {
        return "Pose2D: x=" + this.getX() + " y=" + this.getY() + " theta=" + this.getTheta() + " linearVelocity=" + this.getLinearVelocity() + " angularVelocity=" + this.getAngularVelocity() + " timestamp=" + this.getTimestamp();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStamp);
        dest.writeFloat(this.mX);
        dest.writeFloat(this.mY);
        dest.writeFloat(this.mTheta);
        dest.writeFloat(this.mLinearVelocity);
        dest.writeFloat(this.mAngularVelocity);
    }
}

