package com.segway.robot.algo.dts;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by tangchu on 2017/11/7.
 */

public class BaseControlCommand implements Parcelable{
    private float mLinearVelocity;
    private float mAngularVelocity;
    private int mFollowState;

    public BaseControlCommand(float linear_velocity, float angular_velocity, int follow_state) {
        mLinearVelocity = linear_velocity;
        mAngularVelocity = angular_velocity;
        mFollowState = follow_state;
    }

    protected BaseControlCommand(Parcel in) {
        mLinearVelocity = in.readFloat();
        mAngularVelocity = in.readFloat();
        mFollowState = in.readInt();
    }

    public static final Creator<BaseControlCommand> CREATOR = new Creator<BaseControlCommand>() {
        @Override
        public BaseControlCommand createFromParcel(Parcel in) {
            return new BaseControlCommand(in);
        }

        @Override
        public BaseControlCommand[] newArray(int size) {
            return new BaseControlCommand[size];
        }
    };

    /**
     * Get the linear velocity
     *
     * @return the supposed linear velocity of the robot base
     */
    public float getLinearVelocity() {
        return mLinearVelocity;
    }

    /**
     * Get the angular velocity
     *
     * @return the supposed angular velocity of the robot base
     */
    public float getAngularVelocity() {
        return mAngularVelocity;
    }

    /**
     * Get the follow state
     *
     * @return  follow state
     */
    public int getFollowState() { return mFollowState; }


    @Override
    public String toString() {
        return "BaseControlCommand{" +
                "mLinearVelocity=" + mLinearVelocity +
                ", mAngularVelocity=" + mAngularVelocity +
                ", mFollowState=" + mFollowState +
                "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(mLinearVelocity);
        dest.writeFloat(mAngularVelocity);
        dest.writeInt(mFollowState);
    }

    public interface State {
        int SENSOR_ERROR = -1;
        int NORMAL_FOLLOW = 0;
        int HEAD_FOLLOW_BASE = 1;
    }
}
