package com.segway.robot.algo.tf;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by Yusen.QIN on 2017/10/16.
 */

public class AlgoTfData implements Parcelable {
    public String srcFrameID;
    public String tgtFrameID;
    public long timeStamp;
    public Quaternion q;
    public Translation t;

    protected AlgoTfData(Parcel in) {
        srcFrameID = in.readString();
        tgtFrameID = in.readString();
        timeStamp = in.readLong();
    }

    public static final Creator<AlgoTfData> CREATOR = new Creator<AlgoTfData>() {
        @Override
        public AlgoTfData createFromParcel(Parcel in) {
            return new AlgoTfData(in);
        }

        @Override
        public AlgoTfData[] newArray(int size) {
            return new AlgoTfData[size];
        }
    };

    public AlgoTfData AlgoTfData(String srcID, String tgtID, long timeStamp, Quaternion q, Translation t){
        this.srcFrameID = srcID;
        this.tgtFrameID = tgtID;
        this.timeStamp = timeStamp;
        this.q = q;
        this.t = t;
        return this;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(srcFrameID);
        dest.writeString(tgtFrameID);
        dest.writeLong(timeStamp);
    }
}
