/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.android.JsonStream;
import java.io.File;
import java.util.Locale;

final class DeviceData
implements JsonStream.Streamable {
    private Context appContext;
    private float screenDensity;
    private float dpi;
    private String screenResolution;
    private long totalMemory;
    private boolean rooted;
    private String locale;
    private String id;

    DeviceData(Context appContext) {
        DeviceData deviceData;
        this.appContext = deviceData;
        deviceData = this;
        this.screenDensity = deviceData.appContext.getResources().getDisplayMetrics().density;
        deviceData = this;
        this.dpi = deviceData.appContext.getResources().getDisplayMetrics().densityDpi;
        deviceData = this;
        deviceData = deviceData.appContext.getResources().getDisplayMetrics();
        this.screenResolution = String.format("%dx%d", Math.max(((DisplayMetrics)deviceData).widthPixels, ((DisplayMetrics)deviceData).heightPixels), Math.min(((DisplayMetrics)deviceData).widthPixels, ((DisplayMetrics)deviceData).heightPixels));
        this.totalMemory = Runtime.getRuntime().maxMemory() != Long.MAX_VALUE ? Runtime.getRuntime().maxMemory() : Runtime.getRuntime().totalMemory();
        this.rooted = DeviceData.isRooted();
        this.locale = Locale.getDefault().toString();
        deviceData = this;
        deviceData = deviceData.appContext.getContentResolver();
        this.id = Settings.Secure.getString((ContentResolver)deviceData, (String)"android_id");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void toStream(JsonStream writer) {
        void var1_1;
        writer.beginObject();
        writer.name("manufacturer").value(Build.MANUFACTURER);
        writer.name("brand").value(Build.BRAND);
        writer.name("model").value(Build.MODEL);
        writer.name("screenDensity").value(Float.valueOf(this.screenDensity));
        writer.name("dpi").value(Float.valueOf(this.dpi));
        writer.name("screenResolution").value(this.screenResolution);
        writer.name("totalMemory").value(this.totalMemory);
        writer.name("osName").value("android");
        writer.name("osBuild").value(Build.DISPLAY);
        writer.name("apiLevel").value(Build.VERSION.SDK_INT);
        writer.name("jailbroken").value(this.rooted);
        writer.name("locale").value(this.locale);
        writer.name("osVersion").value(Build.VERSION.RELEASE);
        writer.name("id").value(this.id);
        var1_1.endObject();
    }

    public final String getUserId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isRooted() {
        void var1_1;
        void var0;
        boolean hasTestKeys = Build.TAGS != null && Build.TAGS.contains("test-keys");
        boolean hasSuperUserApk = false;
        try {
            File file = new File("/system/app/Superuser.apk");
            hasSuperUserApk = file.exists();
        }
        catch (Exception exception) {}
        return var0 != false || var1_1 != false;
    }
}

