/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.service;

import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataContent;
import com.sdl.odata.util.ReferenceUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class ODataRequestResponseBase {
    private Map<String, String> headers;
    private final byte[] body;
    private ODataContent streamingContent;

    protected ODataRequestResponseBase(Map<String, String> headers, byte[] body, ODataContent streamingContent) {
        this.headers = headers;
        this.body = body;
        this.streamingContent = streamingContent;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getHeader(String name) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<MediaType> getAccept() {
        String acceptHeader = this.getHeader("Accept");
        if (ReferenceUtil.isNullOrEmpty(acceptHeader)) {
            return Collections.emptyList();
        }
        ArrayList<MediaType> mediaTypesBuilder = new ArrayList<MediaType>();
        for (String part : acceptHeader.split(",")) {
            mediaTypesBuilder.add(MediaType.fromString(part.trim()));
        }
        return Collections.unmodifiableList(mediaTypesBuilder);
    }

    public MediaType getContentType() {
        String contentTypeHeader = this.getHeader("Content-Type");
        return ReferenceUtil.isNullOrEmpty(contentTypeHeader) ? null : MediaType.fromString(contentTypeHeader);
    }

    public byte[] getBody() {
        return this.body;
    }

    public ODataContent getStreamingContent() {
        return this.streamingContent;
    }

    public String getBodyText(String charset) throws UnsupportedEncodingException {
        return new String(this.body, charset);
    }
}

