/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.edm.model;

import com.sdl.odata.api.edm.model.MetaType;
import com.sdl.odata.api.edm.model.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public enum PrimitiveType implements Type
{
    BINARY("Binary", byte[].class),
    BOOLEAN("Boolean", Boolean.TYPE),
    BYTE("Byte", Byte.TYPE),
    DATE("Date", LocalDate.class),
    DATE_TIME_OFFSET("DateTimeOffset", ZonedDateTime.class),
    DURATION("Duration", Period.class),
    TIME_OF_DAY("TimeOfDay", LocalTime.class),
    DECIMAL("Decimal", BigDecimal.class),
    DOUBLE("Double", Double.TYPE),
    SINGLE("Single", Float.TYPE),
    GEOGRAPHY_POINT("GeographyPoint", null),
    GEOGRAPHY_LINE_STRING("GeographyLineString", null),
    GEOGRAPHY_POLYGON("GeographyPolygon", null),
    GEOGRAPHY_MULTI_POINT("GeographyMultiPoint", null),
    GEOGRAPHY_MULTI_LINE_STRING("GeographyMultiLineString", null),
    GEOGRAPHY_MULTI_POLYGON("GeographyMultiPolygon", null),
    GEOGRAPHY_COLLECTION("GeographyCollection", null),
    GEOMETRY_POINT("GeometryPoint", null),
    GEOMETRY_LINE_STRING("GeometryLineString", null),
    GEOMETRY_POLYGON("GeometryPolygon", null),
    GEOMETRY_MULTI_POINT("GeometryMultiPoint", null),
    GEOMETRY_MULTI_LINE_STRING("GeometryMultiLineString", null),
    GEOMETRY_MULTI_POLYGON("GeometryMultiPolygon", null),
    GEOMETRY_COLLECTION("GeometryCollection", null),
    GUID("Guid", UUID.class),
    INT16("Int16", Short.TYPE),
    INT32("Int32", Integer.TYPE),
    INT64("Int64", Long.TYPE),
    STRING("String", String.class),
    SBYTE("SByte", Byte.TYPE);

    private static final Map<String, PrimitiveType> NAME_TO_PRIMITIVE_TYPE;
    private final String name;
    private final Class<?> javaType;

    private PrimitiveType(String name, Class<?> javaType) {
        this.name = name;
        this.javaType = javaType;
    }

    public static PrimitiveType forName(String name) {
        String simpleName = name.startsWith("Edm") ? name.substring("Edm".length() + 1) : name;
        PrimitiveType primitiveType = NAME_TO_PRIMITIVE_TYPE.get(simpleName);
        if (primitiveType == null) {
            throw new IllegalArgumentException("Invalid primitive type name: " + name);
        }
        return primitiveType;
    }

    @Override
    public MetaType getMetaType() {
        return MetaType.PRIMITIVE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespace() {
        return "Edm";
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getNamespace() + "." + this.getName();
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    static {
        HashMap<String, PrimitiveType> nameToPrimitiveTypeMap = new HashMap<String, PrimitiveType>();
        for (PrimitiveType primitiveType : PrimitiveType.values()) {
            nameToPrimitiveTypeMap.put(primitiveType.name, primitiveType);
        }
        NAME_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(nameToPrimitiveTypeMap);
    }
}

