/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.dxa.modules.smarttarget;

import com.sdl.webapp.common.util.InitializationUtils;
import com.tridion.smarttarget.SmartTargetException;
import com.tridion.smarttarget.analytics.AnalyticsManager;
import com.tridion.smarttarget.analytics.tracking.TrackingRedirect;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.WebApplicationInitializer;

public class SmartTargetWebInitializer
implements WebApplicationInitializer {
    private static final Logger log = LoggerFactory.getLogger(SmartTargetWebInitializer.class);

    public void onStartup(ServletContext servletContext) throws ServletException {
        String servletName = "dxaXoTracking";
        String mapping = this.getRedirectUrl();
        servletContext.addServlet(servletName, TrackingRedirect.class).addMapping(new String[]{mapping});
        log.info("XO tracking servlet is added with name {} and mapping {}", (Object)servletName, (Object)mapping);
    }

    private String getRedirectUrl() {
        log.debug("Trying to get redirect link for XO tracking from XO configuration");
        String mapping = this.getTrackingRedirectUrl();
        if (mapping == null) {
            log.debug("Failed to get redirect link for XO tracking from XO configuration, fallback to DXA properties file");
            mapping = InitializationUtils.loadDxaProperties().getProperty("dxa.modules.xo.fallbackRedirectUrl");
            if (mapping == null) {
                log.debug("Failed to get redirect link for XO tracking from properties file, fallback to default value");
                mapping = "/redirect/";
            }
        }
        return mapping;
    }

    private String getTrackingRedirectUrl() {
        try {
            return AnalyticsManager.getConfiguredAnalyticsManager().getConfiguration().getTrackingRedirectUrl();
        }
        catch (SmartTargetException e) {
            log.warn("Failed to get analytics manager configuration", (Throwable)e);
            return null;
        }
    }
}

