/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.dxa.modules.smarttarget.model.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Collections2;
import com.sdl.dxa.caching.NeverCached;
import com.sdl.dxa.modules.smarttarget.model.entity.SmartTargetItem;
import com.sdl.webapp.common.api.localization.Localization;
import com.sdl.webapp.common.api.model.EntityModel;
import com.sdl.webapp.common.api.model.entity.AbstractEntityModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

@NeverCached(qualifier="SmartTargetPromotion")
public class SmartTargetPromotion
extends AbstractEntityModel {
    @JsonProperty(value="Title")
    private String title;
    @JsonProperty(value="Slogan")
    private String slogan;
    @JsonProperty(value="Items")
    private List<SmartTargetItem> items;

    public String getXpmMarkup(Localization localization) {
        Map xpmMetadata = this.getXpmMetadata();
        if (CollectionUtils.isEmpty((Map)xpmMetadata)) {
            return "";
        }
        return String.format("<!-- Start Promotion: { \"PromotionID\": \"%s\", \"RegionID\" : \"%s\" } -->", xpmMetadata.get("PromotionID"), xpmMetadata.get("RegionID"));
    }

    @JsonIgnore
    public Collection<EntityModel> getEntityModels() {
        return Collections2.transform(this.items, SmartTargetItem::getEntity);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartTargetPromotion)) {
            return false;
        }
        SmartTargetPromotion other = (SmartTargetPromotion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$slogan = this.getSlogan();
        String other$slogan = other.getSlogan();
        if (this$slogan == null ? other$slogan != null : !this$slogan.equals(other$slogan)) {
            return false;
        }
        List<SmartTargetItem> this$items = this.getItems();
        List<SmartTargetItem> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmartTargetPromotion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $slogan = this.getSlogan();
        result = result * 59 + ($slogan == null ? 43 : $slogan.hashCode());
        List<SmartTargetItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSlogan() {
        return this.slogan;
    }

    public List<SmartTargetItem> getItems() {
        return this.items;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSlogan(String slogan) {
        this.slogan = slogan;
    }

    public void setItems(List<SmartTargetItem> items) {
        this.items = items;
    }

    public String toString() {
        return "SmartTargetPromotion(title=" + this.getTitle() + ", slogan=" + this.getSlogan() + ", items=" + this.getItems() + ")";
    }
}

