/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.dxa.modules.smarttarget.model.entity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sdl.webapp.common.api.content.ContentProvider;
import com.sdl.webapp.common.api.localization.Localization;
import com.sdl.webapp.common.api.model.EntityModel;
import com.sdl.webapp.common.exceptions.DxaException;
import com.sdl.webapp.common.util.ApplicationContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartTargetItem {
    private static final Logger log = LoggerFactory.getLogger(SmartTargetItem.class);
    private final Localization localization;
    @JsonProperty(value="Entity")
    private EntityModel entity;
    @JsonProperty(value="EntityId")
    private String entityId;

    public SmartTargetItem(String entityId, Localization localization) {
        this.localization = localization;
        this.entityId = entityId;
    }

    public EntityModel getEntity() {
        if (this.entity == null) {
            ContentProvider contentProvider = (ContentProvider)ApplicationContextHolder.getContext().getBean(ContentProvider.class);
            try {
                this.entity = contentProvider.getEntityModel(this.entityId, this.localization);
            }
            catch (DxaException e) {
                log.warn("EntityModel not found for entity id {}", (Object)this.entityId, (Object)e);
            }
        }
        return this.entity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartTargetItem)) {
            return false;
        }
        SmartTargetItem other = (SmartTargetItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Localization this$localization = this.localization;
        Localization other$localization = other.localization;
        if (this$localization == null ? other$localization != null : !this$localization.equals(other$localization)) {
            return false;
        }
        EntityModel this$entity = this.getEntity();
        EntityModel other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        return !(this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SmartTargetItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Localization $localization = this.localization;
        result = result * 59 + ($localization == null ? 43 : $localization.hashCode());
        EntityModel $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        return result;
    }

    public String toString() {
        return "SmartTargetItem(localization=" + this.localization + ", entity=" + this.entity + ", entityId=" + this.entityId + ")";
    }

    private void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }
}

