/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.testinfra.ccm;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.CassandraResourceRule;
import com.datastax.oss.driver.api.testinfra.CassandraSkip;
import com.datastax.oss.driver.api.testinfra.ScyllaRequirement;
import com.datastax.oss.driver.api.testinfra.ScyllaSkip;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.api.testinfra.requirement.BackendRequirementRule;
import com.datastax.oss.driver.api.testinfra.requirement.BackendType;
import java.util.Objects;
import java.util.Optional;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class BaseCcmRule
extends CassandraResourceRule {
    protected final CcmBridge ccmBridge;

    BaseCcmRule(CcmBridge ccmBridge) {
        this.ccmBridge = ccmBridge;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ccmBridge.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    protected void before() {
        this.ccmBridge.create();
        this.ccmBridge.start();
    }

    protected void after() {
        this.ccmBridge.close();
    }

    private Statement buildErrorStatement(final Version requirement, final String description, final boolean lessThan, final boolean dse) {
        return new Statement(){

            public void evaluate() {
                Version version;
                Object[] objectArray = new Object[5];
                Object object = objectArray[0] = lessThan ? "less than" : "at least";
                objectArray[1] = dse ? "DSE" : (CcmBridge.SCYLLA_ENABLEMENT != false ? "SCYLLA" : "C*");
                objectArray[2] = requirement;
                if (dse) {
                    version = BaseCcmRule.this.ccmBridge.getDseVersion().orElse(null);
                } else if (CcmBridge.SCYLLA_ENABLEMENT.booleanValue()) {
                    version = BaseCcmRule.this.ccmBridge.getScyllaVersion().orElse(null);
                } else {
                    BaseCcmRule baseCcmRule = BaseCcmRule.this;
                    version = baseCcmRule.ccmBridge.getCassandraVersion();
                }
                objectArray[3] = version;
                objectArray[4] = description;
                throw new AssumptionViolatedException(String.format("Test requires %s %s %s but %s is configured.  Description: %s", objectArray));
            }
        };
    }

    public Statement apply(Statement base, final Description description) {
        ScyllaSkip scyllaSkip = (ScyllaSkip)description.getAnnotation(ScyllaSkip.class);
        if (scyllaSkip != null && CcmBridge.SCYLLA_ENABLEMENT.booleanValue()) {
            return new Statement(){

                public void evaluate() {
                    throw new AssumptionViolatedException(String.format("Test skipped when running with Scylla.  Description: %s", description));
                }
            };
        }
        CassandraSkip cassandraSkip = (CassandraSkip)description.getAnnotation(CassandraSkip.class);
        if (cassandraSkip != null && !CcmBridge.SCYLLA_ENABLEMENT.booleanValue()) {
            return new Statement(){

                public void evaluate() {
                    throw new AssumptionViolatedException(String.format("Test skipped when running with Cassandra.  Description: %s", description));
                }
            };
        }
        ScyllaRequirement scyllaRequirement = (ScyllaRequirement)description.getAnnotation(ScyllaRequirement.class);
        if (scyllaRequirement != null) {
            Optional<Version> scyllaVersionOption = this.ccmBridge.getScyllaVersion();
            if (!scyllaVersionOption.isPresent()) {
                return new Statement(){

                    public void evaluate() {
                        throw new AssumptionViolatedException("Test has Scylla version requirement, but CCMBridge is not configured for Scylla.");
                    }
                };
            }
            Version scyllaVersion = scyllaVersionOption.get();
            if (CcmBridge.SCYLLA_ENTERPRISE.booleanValue()) {
                Version maxVersion;
                Version minVersion;
                if (!scyllaRequirement.minEnterprise().isEmpty() && (minVersion = Objects.requireNonNull(Version.parse((String)scyllaRequirement.minEnterprise()))).compareTo(scyllaVersion) > 0) {
                    return this.buildErrorStatement(minVersion, scyllaRequirement.description(), false, false);
                }
                if (!scyllaRequirement.maxEnterprise().isEmpty() && (maxVersion = Objects.requireNonNull(Version.parse((String)scyllaRequirement.maxEnterprise()))).compareTo(scyllaVersion) <= 0) {
                    return this.buildErrorStatement(maxVersion, scyllaRequirement.description(), true, false);
                }
            } else {
                Version maxVersion;
                Version minVersion;
                if (!scyllaRequirement.minOSS().isEmpty() && (minVersion = Objects.requireNonNull(Version.parse((String)scyllaRequirement.minOSS()))).compareTo(scyllaVersion) > 0) {
                    return this.buildErrorStatement(minVersion, scyllaRequirement.description(), false, false);
                }
                if (!scyllaRequirement.maxOSS().isEmpty() && (maxVersion = Objects.requireNonNull(Version.parse((String)scyllaRequirement.maxOSS()))).compareTo(CcmBridge.VERSION) <= 0) {
                    return this.buildErrorStatement(maxVersion, scyllaRequirement.description(), true, false);
                }
            }
        }
        if (BackendRequirementRule.meetsDescriptionRequirements(description)) {
            return super.apply(base, description);
        }
        return new Statement(){

            public void evaluate() {
                throw new AssumptionViolatedException(BackendRequirementRule.buildReasonString(description));
            }
        };
    }

    public BackendType getDistribution() {
        return CcmBridge.DISTRIBUTION;
    }

    public boolean isDistributionOf(BackendType type) {
        return CcmBridge.isDistributionOf(type);
    }

    public boolean isDistributionOf(BackendType type, CcmBridge.VersionComparator comparator) {
        return CcmBridge.isDistributionOf(type, comparator);
    }

    public Version getDistributionVersion() {
        return CcmBridge.getDistributionVersion();
    }

    public Version getCassandraVersion() {
        return CcmBridge.getCassandraVersion();
    }

    @Override
    public ProtocolVersion getHighestProtocolVersion() {
        if (CcmBridge.getCassandraVersion().compareTo(Version.V2_2_0) >= 0) {
            return DefaultProtocolVersion.V4;
        }
        return DefaultProtocolVersion.V3;
    }
}

