/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.update;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.querybuilder.BindMarker;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.datastax.oss.driver.api.querybuilder.update.UpdateWithAssignments;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import com.datastax.oss.driver.internal.querybuilder.ImmutableCollections;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultUpdate
implements UpdateStart,
UpdateWithAssignments,
Update {
    private final CqlIdentifier keyspace;
    private final CqlIdentifier table;
    private final Object timestamp;
    private final Object ttlInSeconds;
    private final Object timeout;
    private final ImmutableList<Assignment> assignments;
    private final ImmutableList<Relation> relations;
    private final boolean ifExists;
    private final ImmutableList<Condition> conditions;

    public DefaultUpdate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table) {
        this(keyspace, table, null, null, null, (ImmutableList<Assignment>)ImmutableList.of(), (ImmutableList<Relation>)ImmutableList.of(), false, (ImmutableList<Condition>)ImmutableList.of());
    }

    public DefaultUpdate(@Nullable CqlIdentifier keyspace, @NonNull CqlIdentifier table, @Nullable Object timestamp, @Nullable Object ttlInSeconds, @Nullable Object timeout, @NonNull ImmutableList<Assignment> assignments, @NonNull ImmutableList<Relation> relations, boolean ifExists, @NonNull ImmutableList<Condition> conditions) {
        Preconditions.checkArgument((timestamp == null || timestamp instanceof Long || timestamp instanceof BindMarker ? 1 : 0) != 0, (Object)"TIMESTAMP value must be a BindMarker or a Long");
        Preconditions.checkArgument((ttlInSeconds == null || ttlInSeconds instanceof Integer || ttlInSeconds instanceof BindMarker ? 1 : 0) != 0, (Object)"TTL value must be a BindMarker or an Integer");
        Preconditions.checkArgument((timeout == null || timeout instanceof CqlDuration || timeout instanceof BindMarker ? 1 : 0) != 0, (Object)"TIMEOUT value must be a BindMarker or a CqlDuration");
        this.keyspace = keyspace;
        this.table = table;
        this.timestamp = timestamp;
        this.ttlInSeconds = ttlInSeconds;
        this.timeout = timeout;
        this.assignments = assignments;
        this.relations = relations;
        this.ifExists = ifExists;
        this.conditions = conditions;
    }

    @Override
    @NonNull
    public UpdateStart usingTimestamp(long newTimestamp) {
        return new DefaultUpdate(this.keyspace, this.table, newTimestamp, this.ttlInSeconds, this.timeout, this.assignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public UpdateStart usingTimestamp(@NonNull BindMarker newTimestamp) {
        return new DefaultUpdate(this.keyspace, this.table, newTimestamp, this.ttlInSeconds, this.timeout, this.assignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public UpdateStart usingTtl(int ttlInSeconds) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, ttlInSeconds, this.timeout, this.assignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public UpdateStart usingTtl(@NonNull BindMarker ttlInSeconds) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, ttlInSeconds, this.timeout, this.assignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public UpdateStart usingTimeout(@NonNull CqlDuration timeout) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.ttlInSeconds, timeout, this.assignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public UpdateStart usingTimeout(@NonNull BindMarker timeout) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.ttlInSeconds, timeout, this.assignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public UpdateWithAssignments set(@NonNull Assignment assignment) {
        return this.withAssignments(ImmutableCollections.append(this.assignments, assignment));
    }

    @Override
    @NonNull
    public UpdateWithAssignments set(@NonNull Iterable<Assignment> additionalAssignments) {
        return this.withAssignments(ImmutableCollections.concat(this.assignments, additionalAssignments));
    }

    @NonNull
    public UpdateWithAssignments withAssignments(@NonNull ImmutableList<Assignment> newAssignments) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.ttlInSeconds, this.timeout, newAssignments, this.relations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public Update where(@NonNull Relation relation) {
        return this.withRelations(ImmutableCollections.append(this.relations, relation));
    }

    @Override
    @NonNull
    public Update where(@NonNull Iterable<Relation> additionalRelations) {
        return this.withRelations(ImmutableCollections.concat(this.relations, additionalRelations));
    }

    @NonNull
    public Update withRelations(@NonNull ImmutableList<Relation> newRelations) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.ttlInSeconds, this.timeout, this.assignments, newRelations, this.ifExists, this.conditions);
    }

    @Override
    @NonNull
    public Update ifExists() {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.ttlInSeconds, this.timeout, this.assignments, this.relations, true, this.conditions);
    }

    @Override
    @NonNull
    public Update if_(@NonNull Condition condition) {
        return this.withConditions(ImmutableCollections.append(this.conditions, condition));
    }

    @Override
    @NonNull
    public Update if_(@NonNull Iterable<Condition> additionalConditions) {
        return this.withConditions(ImmutableCollections.concat(this.conditions, additionalConditions));
    }

    @NonNull
    public Update withConditions(@NonNull ImmutableList<Condition> newConditions) {
        return new DefaultUpdate(this.keyspace, this.table, this.timestamp, this.ttlInSeconds, this.timeout, this.assignments, this.relations, false, newConditions);
    }

    @Override
    @NonNull
    public String asCql() {
        StringBuilder builder = new StringBuilder("UPDATE ");
        CqlHelper.qualify(this.keyspace, this.table, builder);
        boolean hasUsing = false;
        if (this.timestamp != null) {
            builder.append(" USING TIMESTAMP ");
            hasUsing = true;
            if (this.timestamp instanceof BindMarker) {
                ((BindMarker)this.timestamp).appendTo(builder);
            } else {
                builder.append(this.timestamp);
            }
        }
        if (this.ttlInSeconds != null) {
            builder.append(hasUsing ? " AND " : " USING ").append("TTL ");
            hasUsing = true;
            if (this.ttlInSeconds instanceof BindMarker) {
                ((BindMarker)this.ttlInSeconds).appendTo(builder);
            } else {
                builder.append(this.ttlInSeconds);
            }
        }
        if (this.timeout != null) {
            builder.append(hasUsing ? " AND " : " USING ").append("TIMEOUT ");
            hasUsing = true;
            if (this.timeout instanceof BindMarker) {
                ((BindMarker)this.timeout).appendTo(builder);
            } else {
                ((CqlDuration)this.timeout).appendTo(builder);
            }
        }
        CqlHelper.append(this.assignments, builder, " SET ", ", ", null);
        CqlHelper.append(this.relations, builder, " WHERE ", " AND ", null);
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        } else {
            CqlHelper.append(this.conditions, builder, " IF ", " AND ", null);
        }
        return builder.toString();
    }

    @Override
    @NonNull
    public SimpleStatement build() {
        return this.builder().build();
    }

    @Override
    @NonNull
    public SimpleStatement build(Object ... values) {
        return this.builder().addPositionalValues(values).build();
    }

    @Override
    @NonNull
    public SimpleStatement build(@NonNull Map<String, Object> namedValues) {
        SimpleStatementBuilder builder = this.builder();
        for (Map.Entry<String, Object> entry : namedValues.entrySet()) {
            builder.addNamedValue(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Override
    @NonNull
    public SimpleStatementBuilder builder() {
        return (SimpleStatementBuilder)SimpleStatement.builder((String)this.asCql()).setIdempotence(Boolean.valueOf(this.isIdempotent()));
    }

    public boolean isIdempotent() {
        if (!this.conditions.isEmpty() || this.ifExists) {
            return false;
        }
        for (Assignment assignment : this.assignments) {
            if (assignment.isIdempotent()) continue;
            return false;
        }
        for (Relation relation : this.relations) {
            if (relation.isIdempotent()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @NonNull
    public CqlIdentifier getTable() {
        return this.table;
    }

    @Nullable
    public Object getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public Object getTtl() {
        return this.ttlInSeconds;
    }

    @Nullable
    public Object getTimeout() {
        return this.timeout;
    }

    @NonNull
    public ImmutableList<Assignment> getAssignments() {
        return this.assignments;
    }

    @NonNull
    public ImmutableList<Relation> getRelations() {
        return this.relations;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    @NonNull
    public ImmutableList<Condition> getConditions() {
        return this.conditions;
    }

    public String toString() {
        return this.asCql();
    }
}

