/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.annotations.ClusteringColumn;
import com.datastax.oss.driver.api.mapper.annotations.Computed;
import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.NamingStrategy;
import com.datastax.oss.driver.api.mapper.annotations.PartitionKey;
import com.datastax.oss.driver.api.mapper.annotations.PropertyStrategy;
import com.datastax.oss.driver.api.mapper.annotations.Transient;
import com.datastax.oss.driver.api.mapper.annotations.TransientProperties;
import com.datastax.oss.driver.api.mapper.entity.naming.GetterStyle;
import com.datastax.oss.driver.api.mapper.entity.naming.NamingConvention;
import com.datastax.oss.driver.api.mapper.entity.naming.SetterStyle;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.entity.CqlNameGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.DefaultEntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.DefaultPropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityFactory;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.mapper.processor.util.AnnotationScanner;
import com.datastax.oss.driver.internal.mapper.processor.util.Capitalizer;
import com.datastax.oss.driver.internal.mapper.processor.util.HierarchyScanner;
import com.datastax.oss.driver.internal.mapper.processor.util.ResolvedAnnotation;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.PropertyType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Maps;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class DefaultEntityFactory
implements EntityFactory {
    private final ProcessorContext context;
    private static final Set<Class<? extends Annotation>> EXCLUSIVE_PROPERTY_ANNOTATIONS = ImmutableSet.of(ClusteringColumn.class, PartitionKey.class, Transient.class, Computed.class);
    private static final Set<Class<? extends Annotation>> PROPERTY_ANNOTATIONS = ImmutableSet.builder().addAll(EXCLUSIVE_PROPERTY_ANNOTATIONS).add(CqlName.class).build();

    public DefaultEntityFactory(ProcessorContext context) {
        this.context = context;
    }

    @Override
    public EntityDefinition getDefinition(TypeElement processedClass) {
        Set<TypeMirror> types = HierarchyScanner.resolveTypeHierarchy(processedClass, this.context);
        LinkedHashSet typeHierarchy = Sets.newLinkedHashSet();
        for (TypeMirror type : types) {
            typeHierarchy.add((TypeElement)this.context.getTypeUtils().asElement(type));
        }
        Language language = Language.detect(typeHierarchy);
        Optional<PropertyStrategy> propertyStrategy = this.getPropertyStrategy(typeHierarchy);
        GetterStyle getterStyle = propertyStrategy.map(PropertyStrategy::getterStyle).orElse(language.defaultGetterStyle);
        SetterStyle setterStyle = propertyStrategy.map(PropertyStrategy::setterStyle).orElse(language.defaultSetterStyle);
        boolean mutable = propertyStrategy.map(PropertyStrategy::mutable).orElse(language.defaultMutable);
        CqlNameGenerator cqlNameGenerator = this.buildCqlNameGenerator(typeHierarchy);
        Set<String> transientProperties = this.getTransientPropertyNames(typeHierarchy);
        HashSet encounteredPropertyNames = Sets.newHashSet();
        TreeMap<Integer, DefaultPropertyDefinition> partitionKey = new TreeMap<Integer, DefaultPropertyDefinition>();
        TreeMap<Integer, DefaultPropertyDefinition> clusteringColumns = new TreeMap<Integer, DefaultPropertyDefinition>();
        ImmutableList.Builder regularColumns = ImmutableList.builder();
        ImmutableList.Builder computedValues = ImmutableList.builder();
        for (TypeElement typeElement : typeHierarchy) {
            for (Element element : typeElement.getEnclosedElements()) {
                PropertyDefinition previous;
                VariableElement field;
                Map<Class<? extends Annotation>, Annotation> propertyAnnotations;
                String setMethodName;
                String propertyName;
                String getMethodName;
                TypeMirror typeMirror;
                ExecutableElement getMethod;
                Set<Modifier> modifiers = element.getModifiers();
                if (element.getKind() != ElementKind.METHOD || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE) || !(getMethod = (ExecutableElement)element).getParameters().isEmpty() || (typeMirror = getMethod.getReturnType()).getKind() == TypeKind.VOID || (getMethodName = getMethod.getSimpleName().toString()).equals("toString") || getMethodName.equals("hashCode") || language == Language.SCALA_CASE_CLASS && (getMethodName.equals("productPrefix") || getMethodName.equals("productArity") || getMethodName.equals("productIterator") || getMethodName.equals("productElementNames") || getMethodName.startsWith("copy$default$")) || language == Language.KOTLIN_DATA_CLASS && getMethodName.matches("component[0-9]+") || (propertyName = this.inferPropertyName(getMethodName, getterStyle, typeMirror)) == null || encounteredPropertyNames.contains(propertyName)) continue;
                if (mutable) {
                    setMethodName = this.inferSetMethodName(propertyName, setterStyle);
                    ExecutableElement setMethod = this.findSetMethod(typeHierarchy, setMethodName, typeMirror);
                    if (setMethod == null) {
                        continue;
                    }
                } else {
                    setMethodName = null;
                }
                if (this.isTransient(propertyAnnotations = this.scanPropertyAnnotations(typeHierarchy, getMethod, field = this.findField(typeHierarchy, propertyName, typeMirror)), propertyName, transientProperties, getMethod, field)) continue;
                int partitionKeyIndex = this.getPartitionKeyIndex(propertyAnnotations);
                int clusteringColumnIndex = this.getClusteringColumnIndex(propertyAnnotations);
                Optional<String> customCqlName = this.getCustomCqlName(propertyAnnotations);
                Optional<String> computedFormula = this.getComputedFormula(propertyAnnotations, getMethod, field);
                PropertyType propertyType = PropertyType.parse(typeMirror, this.context);
                DefaultPropertyDefinition property = new DefaultPropertyDefinition(propertyName, customCqlName, computedFormula, getMethodName, setMethodName, propertyType, cqlNameGenerator);
                encounteredPropertyNames.add(propertyName);
                if (partitionKeyIndex >= 0) {
                    previous = partitionKey.putIfAbsent(partitionKeyIndex, property);
                    if (previous == null) continue;
                    this.context.getMessager().error(getMethod, "Duplicate partition key index: if multiple properties are annotated with @%s, the annotation must be parameterized with an integer indicating the position. Found duplicate index %d for %s and %s.", PartitionKey.class.getSimpleName(), partitionKeyIndex, previous.getGetterName(), property.getGetterName());
                    continue;
                }
                if (clusteringColumnIndex >= 0) {
                    previous = clusteringColumns.putIfAbsent(clusteringColumnIndex, property);
                    if (previous == null) continue;
                    this.context.getMessager().error(getMethod, "Duplicate clustering column index: if multiple properties are annotated with @%s, the annotation must be parameterized with an integer indicating the position. Found duplicate index %d for %s and %s.", ClusteringColumn.class.getSimpleName(), clusteringColumnIndex, previous.getGetterName(), property.getGetterName());
                    continue;
                }
                if (computedFormula.isPresent()) {
                    computedValues.add((Object)property);
                    continue;
                }
                regularColumns.add((Object)property);
            }
        }
        if (encounteredPropertyNames.isEmpty()) {
            this.context.getMessager().error(processedClass, "@%s-annotated class must have at least one property defined.", Entity.class.getSimpleName());
        }
        String entityName = Capitalizer.decapitalize(processedClass.getSimpleName().toString());
        String defaultKeyspace = processedClass.getAnnotation(Entity.class).defaultKeyspace();
        DefaultEntityDefinition entityDefinition = new DefaultEntityDefinition(ClassName.get((TypeElement)processedClass), entityName, defaultKeyspace.isEmpty() ? null : defaultKeyspace, Optional.ofNullable(processedClass.getAnnotation(CqlName.class)).map(CqlName::value), (List<PropertyDefinition>)ImmutableList.copyOf(partitionKey.values()), (List<PropertyDefinition>)ImmutableList.copyOf(clusteringColumns.values()), (List<PropertyDefinition>)regularColumns.build(), (List<PropertyDefinition>)computedValues.build(), cqlNameGenerator, mutable);
        this.validateConstructor(entityDefinition, processedClass);
        return entityDefinition;
    }

    private String inferPropertyName(String getMethodName, GetterStyle getterStyle, TypeMirror type) {
        switch (getterStyle) {
            case FLUENT: {
                return getMethodName;
            }
            case JAVABEANS: {
                if (getMethodName.startsWith("get") && getMethodName.length() > 3) {
                    return Capitalizer.decapitalize(getMethodName.substring(3));
                }
                if (getMethodName.startsWith("is") && getMethodName.length() > 2 && (type.getKind() == TypeKind.BOOLEAN || this.context.getClassUtils().isSame(type, Boolean.class))) {
                    return Capitalizer.decapitalize(getMethodName.substring(2));
                }
                return null;
            }
        }
        throw new AssertionError((Object)("Unsupported getter style " + getterStyle));
    }

    private String inferSetMethodName(String propertyName, SetterStyle setterStyle) {
        String setMethodName;
        switch (setterStyle) {
            case JAVABEANS: {
                setMethodName = "set" + Capitalizer.capitalize(propertyName);
                break;
            }
            case FLUENT: {
                setMethodName = propertyName;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported setter style " + setterStyle));
            }
        }
        return setMethodName;
    }

    @Nullable
    private VariableElement findField(Set<TypeElement> typeHierarchy, String propertyName, TypeMirror fieldType) {
        for (TypeElement classElement : typeHierarchy) {
            if (classElement.getKind().isInterface()) continue;
            for (Element element : classElement.getEnclosedElements()) {
                VariableElement field;
                if (element.getKind() != ElementKind.FIELD || !(field = (VariableElement)element).getSimpleName().toString().equals(propertyName) || !this.context.getTypeUtils().isAssignable(fieldType, field.asType())) continue;
                return field;
            }
        }
        return null;
    }

    @Nullable
    private ExecutableElement findSetMethod(Set<TypeElement> typeHierarchy, String setMethodName, TypeMirror fieldType) {
        for (TypeElement classElement : typeHierarchy) {
            for (Element element : classElement.getEnclosedElements()) {
                Set<Modifier> modifiers = element.getModifiers();
                if (element.getKind() != ElementKind.METHOD || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.PRIVATE)) continue;
                ExecutableElement setMethod = (ExecutableElement)element;
                List<? extends VariableElement> parameters = setMethod.getParameters();
                if (!setMethod.getSimpleName().toString().equals(setMethodName) || parameters.size() != 1 || !this.context.getTypeUtils().isAssignable(fieldType, parameters.get(0).asType())) continue;
                return setMethod;
            }
        }
        return null;
    }

    private Optional<String> getCustomCqlName(Map<Class<? extends Annotation>, Annotation> annotations) {
        CqlName cqlName = (CqlName)annotations.get(CqlName.class);
        return cqlName != null ? Optional.of(cqlName.value()) : Optional.empty();
    }

    private int getPartitionKeyIndex(Map<Class<? extends Annotation>, Annotation> annotations) {
        PartitionKey partitionKey = (PartitionKey)annotations.get(PartitionKey.class);
        return partitionKey != null ? partitionKey.value() : -1;
    }

    private int getClusteringColumnIndex(Map<Class<? extends Annotation>, Annotation> annotations) {
        ClusteringColumn clusteringColumn = (ClusteringColumn)annotations.get(ClusteringColumn.class);
        return clusteringColumn != null ? clusteringColumn.value() : -1;
    }

    private Optional<String> getComputedFormula(Map<Class<? extends Annotation>, Annotation> annotations, ExecutableElement getMethod, @Nullable VariableElement field) {
        Computed annotation = (Computed)annotations.get(Computed.class);
        if (annotation != null) {
            String value = annotation.value();
            if (value.isEmpty()) {
                ExecutableElement element = field != null && field.getAnnotation(Computed.class) != null ? field : getMethod;
                this.context.getMessager().error(element, "@Computed value should be non-empty.", new Object[0]);
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private CqlNameGenerator buildCqlNameGenerator(Set<TypeElement> typeHierarchy) {
        Optional<ResolvedAnnotation<NamingStrategy>> annotation = AnnotationScanner.getClassAnnotation(NamingStrategy.class, typeHierarchy);
        if (!annotation.isPresent()) {
            return CqlNameGenerator.DEFAULT;
        }
        NamingStrategy namingStrategy = annotation.get().getAnnotation();
        TypeElement classElement = (TypeElement)annotation.get().getElement();
        if (namingStrategy == null) {
            return CqlNameGenerator.DEFAULT;
        }
        NamingConvention[] conventions = namingStrategy.convention();
        TypeMirror[] customConverterClasses = this.readCustomConverterClasses(classElement);
        if (conventions.length > 0 && customConverterClasses.length > 0) {
            this.context.getMessager().error(classElement, "Invalid annotation configuration: %s must have either a 'convention' or 'customConverterClass' argument, but not both", NamingStrategy.class.getSimpleName());
            return new CqlNameGenerator(conventions[0]);
        }
        if (conventions.length == 0 && customConverterClasses.length == 0) {
            this.context.getMessager().error(classElement, "Invalid annotation configuration: %s must have either a 'convention' or 'customConverterClass' argument", NamingStrategy.class.getSimpleName());
            return CqlNameGenerator.DEFAULT;
        }
        if (conventions.length > 0) {
            if (conventions.length > 1) {
                this.context.getMessager().warn(classElement, "Too many naming conventions: %s must have at most one 'convention' argument (will use the first one: %s)", NamingStrategy.class.getSimpleName(), conventions[0]);
            }
            return new CqlNameGenerator(conventions[0]);
        }
        if (customConverterClasses.length > 1) {
            this.context.getMessager().warn(classElement, "Too many custom converters: %s must have at most one 'customConverterClass' argument (will use the first one: %s)", NamingStrategy.class.getSimpleName(), customConverterClasses[0]);
        }
        return new CqlNameGenerator(customConverterClasses[0]);
    }

    private TypeMirror[] readCustomConverterClasses(Element classElement) {
        AnnotationMirror annotationMirror = null;
        for (AnnotationMirror annotationMirror2 : classElement.getAnnotationMirrors()) {
            if (!this.context.getClassUtils().isSame(annotationMirror2.getAnnotationType(), NamingStrategy.class)) continue;
            annotationMirror = annotationMirror2;
            break;
        }
        assert (annotationMirror != null);
        for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
            if (!((ExecutableElement)entry.getKey()).getSimpleName().contentEquals("customConverterClass")) continue;
            List values = (List)((AnnotationValue)entry.getValue()).getValue();
            TypeMirror[] result = new TypeMirror[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                result[i] = (TypeMirror)((AnnotationValue)values.get(i)).getValue();
            }
            return result;
        }
        return new TypeMirror[0];
    }

    private boolean isTransient(Map<Class<? extends Annotation>, Annotation> annotations, String propertyName, Set<String> transientProperties, ExecutableElement getMethod, @Nullable VariableElement field) {
        Transient transientAnnotation = (Transient)annotations.get(Transient.class);
        boolean isTransient = transientProperties.contains(propertyName) || transientAnnotation != null || field != null && field.getModifiers().contains((Object)Modifier.TRANSIENT);
        Class<? extends Annotation> exclusiveAnnotation = this.getExclusiveAnnotation(annotations);
        if (isTransient && transientAnnotation == null && exclusiveAnnotation != null) {
            Element element = field != null ? field : getMethod;
            this.context.getMessager().error(element, "Property that is considered transient cannot be annotated with @%s.", exclusiveAnnotation.getSimpleName());
        }
        return isTransient;
    }

    private Set<String> getTransientPropertyNames(Set<TypeElement> typeHierarchy) {
        Optional<ResolvedAnnotation<TransientProperties>> annotation = AnnotationScanner.getClassAnnotation(TransientProperties.class, typeHierarchy);
        return annotation.isPresent() ? Sets.newHashSet((Object[])annotation.get().getAnnotation().value()) : Collections.emptySet();
    }

    private Optional<PropertyStrategy> getPropertyStrategy(Set<TypeElement> typeHierarchy) {
        return AnnotationScanner.getClassAnnotation(PropertyStrategy.class, typeHierarchy).map(ResolvedAnnotation::getAnnotation);
    }

    private void reportMultipleAnnotationError(Element element, Class<? extends Annotation> a0, Class<? extends Annotation> a1) {
        if (a0 == a1) {
            this.context.getMessager().warn(element, "@%s should be used either on the field or the getter, but not both. The annotation on this field will be ignored.", a0.getSimpleName());
        } else {
            this.context.getMessager().error(element, "Properties can't be annotated with both @%s and @%s.", a0.getSimpleName(), a1.getSimpleName());
        }
    }

    private Map<Class<? extends Annotation>, Annotation> scanPropertyAnnotations(Set<TypeElement> typeHierarchy, ExecutableElement getMethod, @Nullable VariableElement field) {
        HashMap annotations = Maps.newHashMap();
        this.scanMethodAnnotations(typeHierarchy, getMethod, annotations);
        if (field != null) {
            this.scanFieldAnnotations(field, annotations);
        }
        return ImmutableMap.copyOf((Map)annotations);
    }

    @Nullable
    private Class<? extends Annotation> getExclusiveAnnotation(Map<Class<? extends Annotation>, Annotation> annotations) {
        for (Class<? extends Annotation> annotationClass : annotations.keySet()) {
            if (!EXCLUSIVE_PROPERTY_ANNOTATIONS.contains(annotationClass)) continue;
            return annotationClass;
        }
        return null;
    }

    private void scanFieldAnnotations(VariableElement field, Map<Class<? extends Annotation>, Annotation> annotations) {
        Class<? extends Annotation> exclusiveAnnotation = this.getExclusiveAnnotation(annotations);
        for (Class<? extends Annotation> annotationClass : PROPERTY_ANNOTATIONS) {
            Annotation annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            if (EXCLUSIVE_PROPERTY_ANNOTATIONS.contains(annotationClass)) {
                if (exclusiveAnnotation == null) {
                    exclusiveAnnotation = annotationClass;
                } else {
                    this.reportMultipleAnnotationError(field, exclusiveAnnotation, annotationClass);
                }
            }
            if (annotations.containsKey(annotationClass)) continue;
            annotations.put(annotationClass, annotation);
        }
    }

    private void scanMethodAnnotations(Set<TypeElement> typeHierarchy, ExecutableElement getMethod, Map<Class<? extends Annotation>, Annotation> annotations) {
        Class<? extends Annotation> exclusiveAnnotation = this.getExclusiveAnnotation(annotations);
        for (Class<? extends Annotation> annotationClass : PROPERTY_ANNOTATIONS) {
            Optional<ResolvedAnnotation<? extends Annotation>> annotation = AnnotationScanner.getMethodAnnotation(annotationClass, getMethod, typeHierarchy);
            if (!annotation.isPresent()) continue;
            if (EXCLUSIVE_PROPERTY_ANNOTATIONS.contains(annotationClass)) {
                if (exclusiveAnnotation == null) {
                    exclusiveAnnotation = annotationClass;
                } else {
                    this.reportMultipleAnnotationError(annotation.get().getElement(), exclusiveAnnotation, annotationClass);
                }
            }
            if (annotations.containsKey(annotationClass)) continue;
            annotations.put(annotationClass, annotation.get().getAnnotation());
        }
    }

    private void validateConstructor(EntityDefinition entity, TypeElement processedClass) {
        if (entity.isMutable()) {
            this.validateNoArgConstructor(processedClass);
        } else {
            this.validateAllColumnsConstructor(processedClass, entity.getAllColumns());
        }
    }

    private void validateNoArgConstructor(TypeElement processedClass) {
        for (Element element : processedClass.getEnclosedElements()) {
            ExecutableElement constructor;
            Set<Modifier> modifiers;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (modifiers = (constructor = (ExecutableElement)element).getModifiers()).contains((Object)Modifier.PRIVATE) || !constructor.getParameters().isEmpty()) continue;
            return;
        }
        this.context.getMessager().error(processedClass, "Mutable @%s-annotated class must have a no-arg constructor.", Entity.class.getSimpleName());
    }

    private void validateAllColumnsConstructor(TypeElement processedClass, List<PropertyDefinition> columns) {
        for (Element element : processedClass.getEnclosedElements()) {
            ExecutableElement constructor;
            Set<Modifier> modifiers;
            if (element.getKind() != ElementKind.CONSTRUCTOR || (modifiers = (constructor = (ExecutableElement)element).getModifiers()).contains((Object)Modifier.PRIVATE) || !this.areAssignable(columns, constructor.getParameters())) continue;
            return;
        }
        String signature = columns.stream().map(column -> String.format("%s %s", column.getType().asTypeMirror(), column.getGetterName())).collect(Collectors.joining(", "));
        this.context.getMessager().error(processedClass, "Immutable @%s-annotated class must have an \"all columns\" constructor. Expected signature: (%s).", Entity.class.getSimpleName(), signature);
    }

    private boolean areAssignable(List<PropertyDefinition> columns, List<? extends VariableElement> parameters) {
        if (columns.size() != parameters.size()) {
            return false;
        }
        for (int i = 0; i < columns.size(); ++i) {
            TypeMirror argumentType = columns.get(i).getType().asTypeMirror();
            TypeMirror parameterType = parameters.get(i).asType();
            if (this.context.getTypeUtils().isAssignable(argumentType, parameterType)) continue;
            return false;
        }
        return true;
    }

    private static enum Language {
        SCALA_CASE_CLASS(false, GetterStyle.FLUENT, null),
        KOTLIN_DATA_CLASS(false, GetterStyle.JAVABEANS, null),
        JAVA14_RECORD(false, GetterStyle.FLUENT, null),
        UNKNOWN(true, GetterStyle.JAVABEANS, SetterStyle.JAVABEANS);

        final boolean defaultMutable;
        final GetterStyle defaultGetterStyle;
        final SetterStyle defaultSetterStyle;

        private Language(boolean defaultMutable, GetterStyle defaultGetterStyle, SetterStyle defaultSetterStyle) {
            this.defaultMutable = defaultMutable;
            this.defaultGetterStyle = defaultGetterStyle;
            this.defaultSetterStyle = defaultSetterStyle;
        }

        static Language detect(Set<TypeElement> typeHierarchy) {
            for (TypeElement type : typeHierarchy) {
                if (Language.isNamed(type, "scala.Product")) {
                    return SCALA_CASE_CLASS;
                }
                if (!Language.isNamed(type, "java.lang.Record")) continue;
                return JAVA14_RECORD;
            }
            TypeElement entityClass = typeHierarchy.iterator().next();
            if (entityClass.getAnnotationMirrors().stream().anyMatch(Language::isKotlinMetadata) && entityClass.getEnclosedElements().stream().anyMatch(e -> Language.isMethodNamed(e, "component1"))) {
                return KOTLIN_DATA_CLASS;
            }
            return UNKNOWN;
        }

        private static boolean isNamed(TypeElement type, String expectedName) {
            Name name = type.getQualifiedName();
            return name != null && name.toString().equals(expectedName);
        }

        private static boolean isKotlinMetadata(AnnotationMirror a) {
            DeclaredType declaredType = a.getAnnotationType();
            if (declaredType.getKind() == TypeKind.DECLARED) {
                TypeElement element = (TypeElement)declaredType.asElement();
                return element.getQualifiedName().toString().equals("kotlin.Metadata");
            }
            return false;
        }

        private static boolean isMethodNamed(Element element, String methodName) {
            return element.getKind() == ElementKind.METHOD && element.getSimpleName().toString().equals(methodName);
        }
    }
}

