/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.internal.mapper.processor.entity.CqlNameGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Optional;

public class DefaultEntityDefinition
implements EntityDefinition {
    private final ClassName className;
    private final CodeBlock cqlName;
    private final List<PropertyDefinition> partitionKey;
    private final List<PropertyDefinition> clusteringColumns;
    private final ImmutableList<PropertyDefinition> regularColumns;
    private final ImmutableList<PropertyDefinition> computedValues;
    private final String defaultKeyspace;
    private final boolean mutable;

    public DefaultEntityDefinition(ClassName className, String javaName, String defaultKeyspace, Optional<String> customCqlName, List<PropertyDefinition> partitionKey, List<PropertyDefinition> clusteringColumns, List<PropertyDefinition> regularColumns, List<PropertyDefinition> computedValues, CqlNameGenerator cqlNameGenerator, boolean mutable) {
        this.className = className;
        this.cqlName = customCqlName.map(n -> CodeBlock.of((String)"$S", (Object[])new Object[]{n})).orElse(cqlNameGenerator.buildCqlName(javaName));
        this.defaultKeyspace = defaultKeyspace;
        this.partitionKey = partitionKey;
        this.clusteringColumns = clusteringColumns;
        this.regularColumns = ImmutableList.copyOf(regularColumns);
        this.computedValues = ImmutableList.copyOf(computedValues);
        this.mutable = mutable;
    }

    @Override
    public ClassName getClassName() {
        return this.className;
    }

    @Override
    public CodeBlock getCqlName() {
        return this.cqlName;
    }

    @Override
    @Nullable
    public String getDefaultKeyspace() {
        return this.defaultKeyspace;
    }

    @Override
    public List<PropertyDefinition> getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public List<PropertyDefinition> getClusteringColumns() {
        return this.clusteringColumns;
    }

    @Override
    public Iterable<PropertyDefinition> getRegularColumns() {
        return this.regularColumns;
    }

    @Override
    public Iterable<PropertyDefinition> getComputedValues() {
        return this.computedValues;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }
}

