/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.util.generation;

import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public abstract class PropertyType {
    private static final ClassName UDT_VALUE_CLASS_NAME = ClassName.get(UdtValue.class);
    public static final ClassName LIST_CLASS_NAME = ClassName.get(List.class);
    public static final ClassName SET_CLASS_NAME = ClassName.get(Set.class);
    public static final ClassName MAP_CLASS_NAME = ClassName.get(Map.class);

    public static PropertyType parse(TypeMirror typeMirror, ProcessorContext context) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            if (declaredType.asElement().getAnnotation(Entity.class) != null) {
                return new SingleEntity(declaredType);
            }
            if (context.getClassUtils().isList(declaredType)) {
                PropertyType elementType = PropertyType.parse(declaredType.getTypeArguments().get(0), context);
                return elementType instanceof Simple ? new Simple(typeMirror) : new EntityList(elementType);
            }
            if (context.getClassUtils().isSet(declaredType)) {
                PropertyType elementType = PropertyType.parse(declaredType.getTypeArguments().get(0), context);
                return elementType instanceof Simple ? new Simple(typeMirror) : new EntitySet(elementType);
            }
            if (context.getClassUtils().isMap(declaredType)) {
                PropertyType keyType = PropertyType.parse(declaredType.getTypeArguments().get(0), context);
                PropertyType valueType = PropertyType.parse(declaredType.getTypeArguments().get(1), context);
                return keyType instanceof Simple && valueType instanceof Simple ? new Simple(typeMirror) : new EntityMap(keyType, valueType);
            }
        }
        return new Simple(typeMirror);
    }

    public abstract TypeName asTypeName();

    public abstract TypeName asRawTypeName();

    public static class EntityMap
    extends PropertyType {
        public final PropertyType keyType;
        public final PropertyType valueType;

        public EntityMap(PropertyType keyType, PropertyType valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public TypeName asTypeName() {
            return ParameterizedTypeName.get((ClassName)MAP_CLASS_NAME, (TypeName[])new TypeName[]{this.keyType.asTypeName(), this.valueType.asTypeName()});
        }

        @Override
        public TypeName asRawTypeName() {
            return ParameterizedTypeName.get((ClassName)MAP_CLASS_NAME, (TypeName[])new TypeName[]{this.keyType.asRawTypeName(), this.valueType.asRawTypeName()});
        }
    }

    public static class EntitySet
    extends PropertyType {
        public final PropertyType elementType;

        public EntitySet(PropertyType elementType) {
            this.elementType = elementType;
        }

        @Override
        public TypeName asTypeName() {
            return ParameterizedTypeName.get((ClassName)SET_CLASS_NAME, (TypeName[])new TypeName[]{this.elementType.asTypeName()});
        }

        @Override
        public TypeName asRawTypeName() {
            return ParameterizedTypeName.get((ClassName)SET_CLASS_NAME, (TypeName[])new TypeName[]{this.elementType.asRawTypeName()});
        }
    }

    public static class EntityList
    extends PropertyType {
        public final PropertyType elementType;

        public EntityList(PropertyType elementType) {
            this.elementType = elementType;
        }

        @Override
        public TypeName asTypeName() {
            return ParameterizedTypeName.get((ClassName)LIST_CLASS_NAME, (TypeName[])new TypeName[]{this.elementType.asTypeName()});
        }

        @Override
        public TypeName asRawTypeName() {
            return ParameterizedTypeName.get((ClassName)LIST_CLASS_NAME, (TypeName[])new TypeName[]{this.elementType.asRawTypeName()});
        }
    }

    public static class SingleEntity
    extends PropertyType {
        public final ClassName entityName;

        public SingleEntity(DeclaredType declaredType) {
            this.entityName = (ClassName)TypeName.get((TypeMirror)declaredType);
        }

        @Override
        public TypeName asTypeName() {
            return this.entityName;
        }

        @Override
        public TypeName asRawTypeName() {
            return UDT_VALUE_CLASS_NAME;
        }
    }

    public static class Simple
    extends PropertyType {
        public final TypeName typeName;

        public Simple(TypeMirror typeMirror) {
            this.typeName = ClassName.get((TypeMirror)typeMirror);
        }

        @Override
        public TypeName asTypeName() {
            return this.typeName;
        }

        @Override
        public TypeName asRawTypeName() {
            return this.typeName;
        }
    }
}

