/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.mapper;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.mapper.MapperBuilder;
import com.datastax.oss.driver.internal.mapper.DefaultMapperContext;
import com.datastax.oss.driver.internal.mapper.processor.GeneratedNames;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.SingleFileCodeGenerator;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class MapperBuilderGenerator
extends SingleFileCodeGenerator {
    private final ClassName builderName;
    private final TypeElement interfaceElement;

    public MapperBuilderGenerator(TypeElement interfaceElement, ProcessorContext context) {
        super(context);
        this.builderName = GeneratedNames.mapperBuilder(interfaceElement);
        this.interfaceElement = interfaceElement;
    }

    @Override
    protected ClassName getPrincipalTypeName() {
        return this.builderName;
    }

    protected Class<? extends CqlSession> getSessionClass() {
        return CqlSession.class;
    }

    @Override
    protected JavaFile.Builder getContents() {
        TypeSpec.Builder classContents = TypeSpec.classBuilder((ClassName)this.builderName).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(MapperBuilder.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)this.interfaceElement)})).addJavadoc("Builds an instance of {@link $T} wrapping a driver {@link $T}.", new Object[]{this.interfaceElement, this.getSessionClass()}).addJavadoc("\n\n<p>", new Object[0]).addJavadoc("Generated by the DataStax driver mapper, do not edit directly.\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.getSessionClass(), "session", new Modifier[0]).addStatement("super(session)", new Object[0]).build()).addMethod(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ClassName.get((TypeElement)this.interfaceElement)).addStatement("$1T context = new $1T(session, defaultKeyspaceId, defaultExecutionProfileName, defaultExecutionProfile, customState)", new Object[]{DefaultMapperContext.class}).addStatement("return new $T(context)", new Object[]{GeneratedNames.mapperImplementation(this.interfaceElement)}).build());
        return JavaFile.builder((String)this.builderName.packageName(), (TypeSpec)classContents.build());
    }
}

